// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/utils/scan_size.c $
// $Rev: 56657 $
// $Date: 2025-09-19 11:05:56 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aics32_scan_size
*
*	Purpose:
*
*		Provide a visual wrapper for the AICS32_IOCTL_SCAN_SIZE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		set		This is the value to apply.
*
*		get		The results are reported here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aics32_scan_size(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("Scan Size", index);

	ret		= aics32_ioctl(fd, AICS32_IOCTL_SCAN_SIZE, &set);
	errs	= ret ? 1 : 0;


	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case AICS32_SCAN_SIZE_SINGLE:

			ptr	= "One Channel";
			break;

		case AICS32_SCAN_SIZE_0_1:

			ptr	= "2 Channels (0-1)";
			break;

		case AICS32_SCAN_SIZE_0_3:

			ptr	= "4 Channels (0-3)";
			break;

		case AICS32_SCAN_SIZE_0_7:

			ptr	= "8 Channels (0-7)";
			break;

		case AICS32_SCAN_SIZE_0_15:

			ptr	= "16 Channels (0-15)";
			break;

		case AICS32_SCAN_SIZE_0_31:

			ptr	= "32 Channels (0-31)";
			break;

		case AICS32_SCAN_SIZE_0_63:

			ptr	= "64 Channels (0-63, Single Ended Only)";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


