// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/utils/read.c $
// $Rev: 56657 $
// $Date: 2025-09-19 11:05:56 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aics32_read_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device read call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		dst		The data read is placed here.
*
*		bytes	The volume of data to read.
*
*		got		The results are reported here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aics32_read_util(int fd, int index, int verbose, void* dst, size_t bytes, size_t* got)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Reading", index);

	ret	= aics32_read(fd, dst, bytes);
	errs	= (ret < 0) ? 1 : 0;

	if (verbose == 0)
	{
	}
	else if (ret >= 0)
	{
		printf("PASS  (%d Byte%s)\n", ret, (ret == 1) ? "" : "s");
	}
	else
	{
		printf(	"FAIL <---  (requested %ld Byte%s, ret = %ld)\n",
				(long) bytes,
				(bytes == 1) ? "" : "s",
				(long) ret);
	}

	if (got)
		got[0]	= (ret >= 0) ? ret : 0;

	return(errs);
}


