// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/utils/rbg_nrate.c $
// $Rev: 56657 $
// $Date: 2025-09-19 11:05:56 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aics32_rbg_nrate
*
*	Purpose:
*
*		Provide a visual wrapper for the AICS32_IOCTL_RBG_NRATE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		set		This is the value to apply.
*
*		get		The results are reported here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aics32_rbg_nrate(int fd, int index, int verbose, s32 set, s32* get)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Rate-B Gen. Nrate", index);

	ret		= aics32_ioctl(fd, AICS32_IOCTL_RBG_NRATE, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s  (%ld)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


