// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/utils/id.c $
// $Rev: 56657 $
// $Date: 2025-09-19 11:05:56 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	_id_device_pci
*
*	Purpose:
*
*		Identify the device using the PCI registers.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

static int _id_device_pci(int fd)
{
	int	errs	= 0;
	u32	reg;

	gsc_label("Vendor ID");
	errs	+= aics32_reg_read(fd, -1, 0, GSC_PCI_9080_VIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Device ID");
	errs	+= aics32_reg_read(fd, -1, 0, GSC_PCI_9080_DIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x9080)
	{
		printf("(PCI9080)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Sub Vendor ID");
	errs	+= aics32_reg_read(fd, -1, 0, GSC_PCI_9080_SVID, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Subsystem ID");
	errs	+= aics32_reg_read(fd, -1, 0, GSC_PCI_9080_SID, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x3010)
	{
		printf("(16AICS32)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	aics32_id_device
*
*	Purpose:
*
*		Identify the device.
*
*	Arguments:
*
*		fd		The handle to use to access the device.
*
*		index	The index of the device or -1 if we don't care.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aics32_id_device(int fd, int index, int verbose)
{
	s32			device_type;
	int			errs;
	const char*	psz		= "";

	if (verbose)
		gsc_label_index("Device", index);

	errs	= aics32_query(fd, -1, 0, AICS32_QUERY_DEVICE_TYPE, &device_type);

	if (errs == 0)
	{
		switch (device_type)
		{
			default:

				errs	= 1;

				if (verbose)
				{
					printf(	"FAIL <---  (unexpected device type: %ld)",
							(long) device_type);
				}

				break;

			case GSC_DEV_TYPE_16AICS32:

				psz	= "16AICS32";
				break;
		}
	}

	if (verbose)
	{
		printf("%s\n", psz);
		gsc_label_level_inc();
	}

	errs	+= _id_device_pci(fd);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}



