// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/utils/config_ai.c $
// $Rev: 56657 $
// $Date: 2025-09-19 11:05:56 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aics32_config_ai
*
*	Purpose:
*
*		Configure the given device using common defaults.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		size	The desired scan size.
*
*		fsamp	The desired sample rate.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	aics32_config_ai(int fd, int index, int verbose, s32 size, s32 fsamp)
{
	s32	enable_a;
	s32	enable_b;
	int	errs	= 0;
	s32	nrate_a;
	s32	nrate_b;
	s32	src;
	s32	src_b;

	if (verbose)
	{
		gsc_label_index("Input Configuration", index);
		printf("\n");
		gsc_label_level_inc();
	}

	errs	+= aics32_initialize			(fd, index, verbose);

	// Settings must be applied after the initialization call!

	errs	+= aics32_rx_io_mode			(fd, index, verbose, GSC_IO_MODE_PIO,				NULL);
	errs	+= aics32_rx_io_timeout			(fd, index, verbose, AICS32_IO_TIMEOUT_DEFAULT,		NULL);
	errs	+= aics32_ai_buf_thr_lvl		(fd, index, verbose, 60000,							NULL);
	errs	+= aics32_ai_mode				(fd, index, verbose, AICS32_AI_MODE_DIFF,			NULL);
	errs	+= aics32_ai_range				(fd, index, verbose, AICS32_AI_RANGE_10V,			NULL);
	errs	+= aics32_scan_size				(fd, index, verbose, size,							NULL);
	errs	+= aics32_scan_single			(fd, index, verbose, 0,								NULL);
	errs	+= aics32_data_format			(fd, index, verbose, AICS32_DATA_FORMAT_OFF_BIN,	NULL);
	errs	+= aics32_excitation_mask_set	(fd, index, verbose, 0x00000000);
	errs	+= aics32_excitation_test		(fd, index, verbose, AICS32_EXCITATION_TEST_OFF,	NULL);
	errs	+= aics32_ext_sync				(fd, index, verbose, AICS32_EXT_SYNC_DISABLE,		NULL);
	errs	+= aics32_fsamp_ai_compute		(fd, index, verbose, fsamp, &src, &src_b, &nrate_a, &nrate_b, &enable_a, &enable_b, NULL);
	errs	+= aics32_ai_clk_src			(fd, index, verbose, src,							NULL);
	errs	+= aics32_rbg_clk_src			(fd, index, verbose, src_b,							NULL);
	errs	+= aics32_rag_nrate				(fd, index, verbose, nrate_a,						NULL);
	errs	+= aics32_rbg_nrate				(fd, index, verbose, nrate_b,						NULL);
	errs	+= aics32_rag_enable			(fd, index, verbose, enable_a,						NULL);
	errs	+= aics32_rbg_enable			(fd, index, verbose, enable_b,						NULL);

	errs	+= aics32_fsamp_ai_report_all	(fd, index, verbose,								NULL);

	// Settings affecting the sample rate or voltage range must generally
	// be applied before autocalibration.
	// Refer to the board user manual for clarification.
//	errs	+= aics32_autocal			(fd, index, verbose);	// Cable may need disconnecting for this.

	// Interrupt selections should be applied after autocalibration as the
	// driver overwrites the current selection to detect the Autocalibration
	// Done interrupt. If an application intends to detect the Autocalibration
	// Done interrupt, then the interrupt selection may be made beforehand.
	errs	+= aics32_irq0_sel				(fd, index, verbose, AICS32_IRQ0_INIT_DONE,			NULL);
	errs	+= aics32_irq1_sel				(fd, index, verbose, AICS32_IRQ1_NONE,				NULL);

	// The final step is to clear the buffer.
	errs	+= aics32_ai_buf_clear			(fd, index, verbose);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


