// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/utils/autocal.c $
// $Rev: 56657 $
// $Date: 2025-09-19 11:05:56 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aics32_autocal
*
*	Purpose:
*
*		Provide a visual wrapper for the AICS32_IOCTL_AUTOCAL service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aics32_autocal(int fd, int index, int verbose)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Autocalibrate", index);

	ret		= aics32_ioctl(fd, AICS32_IOCTL_AUTOCAL, NULL);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}


