// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/utils/auto_cal_sts.c $
// $Rev: 56657 $
// $Date: 2025-09-19 11:05:56 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Utilities: source file

#include "main.h"



// Retained for backwards compatibility.

/******************************************************************************
*
*	Function:	aics32_auto_cal_sts
*
*	Purpose:
*
*		Provide a visual wrapper for the AICS32_IOCTL_AUTO_CAL_STS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		get		The results are reported here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aics32_auto_cal_sts(int fd, int index, int verbose, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr		= buf;
	int			ret;
	s32			set;

	if (verbose)
		gsc_label_index("Autocal Status", index);

	ret		= aics32_ioctl(fd, AICS32_IOCTL_AUTO_CAL_STS, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case AICS32_AUTO_CAL_STS_ACTIVE:

			ptr	= "Active";
			break;

		case AICS32_AUTO_CAL_STS_FAIL:

			ptr	= "Failed";
			break;

		case AICS32_AUTO_CAL_STS_PASS:

			ptr	= "Passed";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


