// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/utils/ai_buf_level.c $
// $Rev: 56657 $
// $Date: 2025-09-19 11:05:56 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aics32_ai_buf_level
*
*	Purpose:
*
*		Provide a visual wrapper for the AICS32_IOCTL_AI_BUF_LEVEL service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		get		The results are reported here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aics32_ai_buf_level(int fd, int index, int verbose, s32* get)
{
	int	errs;
	int	ret;
	s32	set;

	if (verbose)
		gsc_label_index("AI Buffer Level", index);

	ret		= aics32_ioctl(fd, AICS32_IOCTL_AI_BUF_LEVEL, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s  (%ld samples)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


