// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/samples/signals/perform.c $
// $Rev: 56665 $
// $Date: 2025-09-19 11:12:15 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	char	buf[64];
	int		errs	= 0;
	s32		sps		= 0;

	//===============================================================
	gsc_label("Sync Output");
	printf("\n");

	gsc_label_level_inc();

	errs	+= aics32_initialize		(args->fd, -1, 1);
	errs	+= aics32_ai_mode			(args->fd, -1, 1, AICS32_AI_MODE_DIFF,		NULL);
	errs	+= aics32_ext_sync			(args->fd, -1, 1, AICS32_EXT_SYNC_ENABLE,	NULL);
	errs	+= aics32_ai_clk_src		(args->fd, -1, 1, AICS32_AI_CLK_SRC_RAG,	NULL);
	errs	+= aics32_rag_nrate			(args->fd, -1, 1, 24000,					NULL);
	errs	+= aics32_rag_enable		(args->fd, -1, 1, AICS32_GEN_ENABLE_YES,	NULL);
	errs	+= aics32_fsamp_ai_report	(args->fd, -1, -1, 0, &sps);

	gsc_label_level_dec();

	//===============================================================
	sprintf(buf, "Waiting (%ld sec%s)", (long) args->seconds, (args->seconds == 1) ? "" : "s");
	gsc_label(buf);
	os_sleep_ms(args->seconds * 1000);
	printf("Done\n");

	return(errs);
}



