// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/samples/rxrate/perform.c $
// $Rev: 56663 $
// $Date: 2025-09-19 11:11:49 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_64K		(64 * 1024)	// size of driver's transfer buffer



// variables ******************************************************************

static	u8	_data[_64K * 4];



//*****************************************************************************
static int _configuration(const args_t* args)
{
	int	errs	= 0;

	gsc_label("Configuration");
	errs	+= aics32_config_ai(args->fd, -1, 0, AICS32_SCAN_SIZE_0_31, 3125);
	printf("%s\n", errs ? "FAIL <---" : "PASS");

	errs	+= aics32_rx_io_mode(args->fd, -1, 1, args->io_mode, NULL);

	return(errs);
}



//*****************************************************************************
static int _rate_test(const args_t* args, long get)
{
	struct timeval	begin;
	int				errs	= 0;
	long			got;
	long long		limit	= (long long) args->rx_mb * 1000000L;
	struct timeval	minimum;
	struct timeval	now;
	long long		sps;
	long long		total	= 0;
	long			us;

	gsc_label("Reading");
	errs	+= aics32_ai_buf_clear(args->fd, -1, 0);

	gettimeofday(&begin, NULL);
	minimum.tv_sec	= begin.tv_sec + args->seconds;
	minimum.tv_usec	= begin.tv_usec;

	for (;;)
	{
		got	= aics32_read(args->fd, _data, get);

		if (got < 0)
		{
			errs++;
			printf("FAIL <--- (read");
			printf(", total so far %lld", total);
			printf(", requested %ld bytes", (long) get);
			printf(", error %ld)\n", got);
			break;
		}

		gettimeofday(&now, NULL);
		total	+= got;

		if (total < limit)
			continue;

		if (now.tv_sec < minimum.tv_sec)
			continue;

		if ((now.tv_sec == minimum.tv_sec) && (now.tv_usec < minimum.tv_usec))
			continue;

		us	= (now.tv_sec - begin.tv_sec) * 1000000L
			+ (now.tv_usec - begin.tv_usec);
		sps	= (total * 10000000L / 4 / us + 5) / 10;

		printf(	"PASS  (");
		gsc_label_long_comma(total / 4);
		printf(" Samples, %ld.%06ld Seconds, ", us / 1000000, us % 1000000);
		gsc_label_long_comma(sps);
		printf(" S/S)\n");
		break;
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int		errs	= 0;
	long	get		= sizeof(_data);

	errs	+= _configuration(args);

	gsc_label("Read Rate");
	printf("(minimum seconds: ");
	gsc_label_long_comma(args->seconds);
	printf(", MB minimum:");
	gsc_label_long_comma(args->rx_mb);
	printf(")\n");
	gsc_label_level_inc();

	errs	+= _rate_test(args, get);

	gsc_label_level_dec();
	return(errs);
}



