// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/samples/irq/irq1.c $
// $Rev: 56661 $
// $Date: 2025-09-19 11:10:25 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _low_2_high_add_data(const args_t* args)
{
	int	errs	= 0;
	int	ret;
	s32	val;

	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_INITIALIZE, NULL);
	errs	+= ret ? 1 : 0;

	val		= AICS32_AI_CLK_SRC_RAG;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_AI_CLK_SRC, &val);
	errs	+= ret ? 1 : 0;

	val		= 3480;	// should take about 1/10 of a second
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_AI_BUF_THR_LVL, &val);
	errs	+= ret ? 1 : 0;

	val		= AICS32_IRQ1_IN_BUF_THR_L2H;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_IRQ1_SEL, &val);
	errs	+= ret ? 1 : 0;

	val		= AICS32_GEN_ENABLE_YES;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_RAG_ENABLE, &val);
	errs	+= ret ? 1 : 0;

	// Allow time for the interrupt.
	os_sleep_ms(10);
	return(errs);
}



//*****************************************************************************
static int _irq1_ai_buf_thr_sts_l2h_test(const args_t* args)
{
	int	errs;

	gsc_label("Buffer Status Low-to-High");
	errs	= irq_wait_test(args, AICS32_WAIT_GSC_IN_BUF_THR_L2H, _low_2_high_add_data);
	return(errs);
}



//*****************************************************************************
static int _high_2_low_ai_read_data(const args_t* args)
{
	u32		buf[1024];
	int		errs	= 0;
	int		i;
	int		ret;
	s32		val;

	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_INITIALIZE, NULL);
	errs	+= ret ? 1 : 0;

	val		= 1;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_AI_BUF_THR_LVL, &val);
	errs	+= ret ? 1 : 0;

	val		= AICS32_GEN_ENABLE_YES;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_RAG_ENABLE, &val);
	errs	+= ret ? 1 : 0;

	os_sleep_ms(100);

	val		= AICS32_GEN_ENABLE_NO;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_RAG_ENABLE, &val);
	errs	+= ret ? 1 : 0;

	val		= AICS32_IRQ1_IN_BUF_THR_H2L;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_IRQ1_SEL, &val);
	errs	+= ret ? 1 : 0;

	val		= GSC_IO_MODE_PIO;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_RX_IO_MODE, &val);
	errs	+= ret ? 1 : 0;

	val		= 0;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_RX_IO_TIMEOUT, &val);
	errs	+= ret ? 1 : 0;

	for (i = 0; i <= 100; i++)
		aics32_read(args->fd, buf, sizeof(buf));

	// Allow plenty of time for the interrupt.
	os_sleep_ms(10);
	return(errs);
}



//*****************************************************************************
static int _irq1_ai_buf_thr_sts_h2l_test(const args_t* args)
{
	int	errs;

	gsc_label("Buffer Status High-to-Low");
	errs	= irq_wait_test(args, AICS32_WAIT_GSC_IN_BUF_THR_H2L, _high_2_low_ai_read_data);
	return(errs);
}



//*****************************************************************************
int irq1_test(const args_t* args)
{
	int	errs	= 0;

	gsc_label("IRQ1");
	printf("\n");
	gsc_label_level_inc();

	errs	+= _irq1_ai_buf_thr_sts_l2h_test(args);
	errs	+= _irq1_ai_buf_thr_sts_h2l_test(args);

	gsc_label_level_dec();
	return(errs);
}


