// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/samples/irq/irq0.c $
// $Rev: 56661 $
// $Date: 2025-09-19 11:10:25 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _init(const args_t* args)
{
	int	errs;
	int	ret;

	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_INITIALIZE, NULL);
	errs	= ret ? 1 : 0;
	return(errs);
}



//*****************************************************************************
static int _irq0_initialize_test(const args_t* args)
{
	int	errs	= 0;

	gsc_label("Initialize");
	errs	+= irq_wait_test(args, AICS32_WAIT_GSC_INIT_DONE, _init);
	return(errs);
}



//*****************************************************************************
static int _autocal(const args_t* args)
{
	int	errs	= 0;
	int	ret;

	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_INITIALIZE, NULL);
	errs	+= ret ? 1 : 0;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_AUTOCAL, NULL);
	errs	+= ret ? 1 : 0;
	return(errs);
}



//*****************************************************************************
static int _irq0_autocal(const args_t* args)
{
	int	errs;

	gsc_label("Autocalibrate");
	errs	= irq_wait_test(args, AICS32_WAIT_GSC_AUTOCAL_DONE, _autocal);
	return(errs);
}



//*****************************************************************************
static int _scan_start(const args_t* args)
{
	int	errs	= 0;
	int	ret;
	s32	val;

	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_INITIALIZE, NULL);
	errs	+= ret ? 1 : 0;

	val		= AICS32_IRQ0_SCAN_START;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_IRQ0_SEL, &val);
	errs	+= ret ? 1 : 0;

	val		= AICS32_AI_CLK_SRC_BCR;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_AI_CLK_SRC, &val);
	errs	+= ret ? 1 : 0;

	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_INPUT_SYNC, NULL);
	errs	+= ret ? 1 : 0;
	return(errs);
}



//*****************************************************************************
static int _irq0_scan_start_test(const args_t* args)
{
	int	errs;

	gsc_label("Scan Start");
	errs	= irq_wait_test(args, AICS32_WAIT_GSC_SCAN_START, _scan_start);
	return(errs);
}



//*****************************************************************************
static int _scan_done(const args_t* args)
{
	int	errs	= 0;
	int	ret;
	s32	val;

	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_INITIALIZE, NULL);
	errs	+= ret ? 1 : 0;

	val		= AICS32_IRQ0_SCAN_DONE;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_IRQ0_SEL, &val);
	errs	+= ret ? 1 : 0;

	val		= AICS32_AI_CLK_SRC_BCR;
	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_AI_CLK_SRC, &val);
	errs	+= ret ? 1 : 0;

	ret		= aics32_ioctl(args->fd, AICS32_IOCTL_INPUT_SYNC, NULL);
	errs	+= ret ? 1 : 0;
	return(errs);
}



//*****************************************************************************
static int _irq0_scan_done_test(const args_t* args)
{
	int	errs;

	gsc_label("Scan Done");
	errs	= irq_wait_test(args, AICS32_WAIT_GSC_SCAN_DONE, _scan_done);
	return(errs);
}



//*****************************************************************************
int irq0_test(const args_t* args)
{
	int	errs	= 0;

	gsc_label("IRQ0");
	printf("\n");
	gsc_label_level_inc();

	errs	+= _irq0_initialize_test(args);
	errs	+= _irq0_autocal(args);
	errs	+= _irq0_scan_start_test(args);
	errs	+= _irq0_scan_done_test(args);

	gsc_label_level_dec();
	return(errs);
}


