// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/samples/fsamp/perform.c $
// $Rev: 52047 $
// $Date: 2022-11-22 10:53:14 -0600 (Tue, 22 Nov 2022) $

// 16AICS32: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	FILE_NAME				"fsamp.txt"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	s32		enable_a;
	s32		enable_b;
	int		errs	= 0;
	FILE*	file	= NULL;
	s32		fsamp;
	s32		max		= 0;
	s32		min		= 0;
	s32		nrate_a;
	s32		nrate_b;
	double	rate;
	s32		src;
	s32		src_b;

	gsc_label("Fsamp Computation");
	printf("\n");
	gsc_label_level_inc();

	if (args->range == 0)
	{
		min		= args->fsamp;
		max		= args->fsamp;
	}
	else
	{
		errs	+= aics32_query(args->fd, -1, 0, AICS32_QUERY_FSAMP_MAX, &max);
		errs	+= aics32_query(args->fd, -1, 0, AICS32_QUERY_FSAMP_MIN, &min);
	}

	if (args->save)
	{
		file	= fopen(FILE_NAME, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", FILE_NAME);
			errs	= 1;
		}
		else
		{
			fprintf(file, "# 16AICS32 Scan Rates\n");
			fprintf(file, "# Request   Produced\n");
			fprintf(file, "# ========  ==========\n");
		}
	}

	for (fsamp = min; fsamp <= max; fsamp++)
	{
		errs	+= aics32_fsamp_ai_compute(args->fd, -1, 1, fsamp, &src, &src_b, &nrate_a, &nrate_b, &enable_a, &enable_b, &rate);

		if (file)
			fprintf(file, "%10ld  %10.3f\n", (long) fsamp, (double) rate);
	}

	if (file)
		fclose(file);

	gsc_label_level_dec();
	return(errs);
}


