// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/pci_plx/gsc_pci9080.h $
// $Rev: 56589 $
// $Date: 2025-08-20 13:18:55 -0500 (Wed, 20 Aug 2025) $

// OS & Device Independent: Device Driver: PLX: header file

#ifndef	__GSC_PCI9080_H__
#define	__GSC_PCI9080_H__

#include "gsc_common.h"



// macros *********************************************************************

#define	GSC_PCI_9080_ENCODE(s,o)	GSC_REG_ENCODE(GSC_REG_TYPE_PCI,(s),(o))
#define	GSC_PLX_9080_ENCODE(s,o)	GSC_REG_ENCODE(GSC_REG_TYPE_BAR0,(s),(o))

// PLX PCI9080 PCI Configuration Registers
#define	GSC_PCI_9080_VIDR			GSC_PCI_9080_ENCODE(2, 0x00)
#define	GSC_PCI_9080_DIDR			GSC_PCI_9080_ENCODE(2, 0x02)
#define	GSC_PCI_9080_CR				GSC_PCI_9080_ENCODE(2, 0x04)
#define	GSC_PCI_9080_SR				GSC_PCI_9080_ENCODE(2, 0x06)
#define	GSC_PCI_9080_REV			GSC_PCI_9080_ENCODE(1, 0x08)
#define	GSC_PCI_9080_CCR			GSC_PCI_9080_ENCODE(3, 0x09)
#define	GSC_PCI_9080_CLSR			GSC_PCI_9080_ENCODE(1, 0x0C)
#define	GSC_PCI_9080_LTR			GSC_PCI_9080_ENCODE(1, 0x0D)
#define	GSC_PCI_9080_HTR			GSC_PCI_9080_ENCODE(1, 0x0E)
#define	GSC_PCI_9080_BISTR			GSC_PCI_9080_ENCODE(1, 0x0F)
#define	GSC_PCI_9080_BAR0			GSC_PCI_9080_ENCODE(4, 0x10)
#define	GSC_PCI_9080_BAR1			GSC_PCI_9080_ENCODE(4, 0x14)
#define	GSC_PCI_9080_BAR2			GSC_PCI_9080_ENCODE(4, 0x18)
#define	GSC_PCI_9080_BAR3			GSC_PCI_9080_ENCODE(4, 0x1C)
#define	GSC_PCI_9080_BAR4			GSC_PCI_9080_ENCODE(4, 0x20)
#define	GSC_PCI_9080_BAR5			GSC_PCI_9080_ENCODE(4, 0x24)
#define	GSC_PCI_9080_CIS			GSC_PCI_9080_ENCODE(4, 0x28)
#define	GSC_PCI_9080_SVID			GSC_PCI_9080_ENCODE(2, 0x2C)
#define	GSC_PCI_9080_SID			GSC_PCI_9080_ENCODE(2, 0x2E)
#define	GSC_PCI_9080_ERBAR			GSC_PCI_9080_ENCODE(4, 0x30)
#define	GSC_PCI_9080_ILR			GSC_PCI_9080_ENCODE(1, 0x3C)
#define	GSC_PCI_9080_IPR			GSC_PCI_9080_ENCODE(1, 0x3D)
#define	GSC_PCI_9080_MGR			GSC_PCI_9080_ENCODE(1, 0x3E)
#define	GSC_PCI_9080_MLR			GSC_PCI_9080_ENCODE(1, 0x3F)

// PLX PCI9080 feature set registers: Local Configuration Registers
#define	GSC_PLX_9080_LAS0RR			GSC_PLX_9080_ENCODE(4, 0x00)
#define	GSC_PLX_9080_LAS0BA			GSC_PLX_9080_ENCODE(4, 0x04)
#define	GSC_PLX_9080_MARBR			GSC_PLX_9080_ENCODE(4, 0x08)
#define	GSC_PLX_9080_BIGEND			GSC_PLX_9080_ENCODE(4, 0x0C)
#define	GSC_PLX_9080_EROMRR			GSC_PLX_9080_ENCODE(4, 0x10)
#define	GSC_PLX_9080_EROMBA			GSC_PLX_9080_ENCODE(4, 0x14)
#define	GSC_PLX_9080_LBRD0			GSC_PLX_9080_ENCODE(4, 0x18)
#define	GSC_PLX_9080_DMRR			GSC_PLX_9080_ENCODE(4, 0x1C)
#define	GSC_PLX_9080_DMLBAM			GSC_PLX_9080_ENCODE(4, 0x20)
#define	GSC_PLX_9080_DMLBAI			GSC_PLX_9080_ENCODE(4, 0x24)
#define	GSC_PLX_9080_DMPBAM			GSC_PLX_9080_ENCODE(4, 0x28)
#define	GSC_PLX_9080_DMCFGA			GSC_PLX_9080_ENCODE(4, 0x2C)
#define	GSC_PLX_9080_LAS1RR			GSC_PLX_9080_ENCODE(4, 0xF0)
#define	GSC_PLX_9080_LAS1BA			GSC_PLX_9080_ENCODE(4, 0xF4)
#define	GSC_PLX_9080_LBRD1			GSC_PLX_9080_ENCODE(4, 0xF8)

// PLX PCI9080 feature set registers: Runtime Registers
#define	GSC_PLX_9080_MBOX0			GSC_PLX_9080_ENCODE(4, 0x40)
#define	GSC_PLX_9080_MBOX1			GSC_PLX_9080_ENCODE(4, 0x44)
#define	GSC_PLX_9080_MBOX2			GSC_PLX_9080_ENCODE(4, 0x48)
#define	GSC_PLX_9080_MBOX3			GSC_PLX_9080_ENCODE(4, 0x4C)
#define	GSC_PLX_9080_MBOX4			GSC_PLX_9080_ENCODE(4, 0x50)
#define	GSC_PLX_9080_MBOX5			GSC_PLX_9080_ENCODE(4, 0x54)
#define	GSC_PLX_9080_MBOX6			GSC_PLX_9080_ENCODE(4, 0x58)
#define	GSC_PLX_9080_MBOX7			GSC_PLX_9080_ENCODE(4, 0x5C)
#define	GSC_PLX_9080_P2LDBELL		GSC_PLX_9080_ENCODE(4, 0x60)
#define	GSC_PLX_9080_L2PDBELL		GSC_PLX_9080_ENCODE(4, 0x64)
#define	GSC_PLX_9080_INTCSR			GSC_PLX_9080_ENCODE(4, 0x68)
#define	GSC_PLX_9080_CNTRL			GSC_PLX_9080_ENCODE(4, 0x6C)
#define	GSC_PLX_9080_VIDR			GSC_PLX_9080_ENCODE(2, 0x70)	// hard coded
#define	GSC_PLX_9080_DIDR			GSC_PLX_9080_ENCODE(2, 0x72)	// hard coded
#define	GSC_PLX_9080_REV			GSC_PLX_9080_ENCODE(1, 0x74)

// PLX PCI9080 feature set registers: DMA Registers
#define	GSC_PLX_9080_DMAMODE0		GSC_PLX_9080_ENCODE(4, 0x80)
#define	GSC_PLX_9080_DMAPADR0		GSC_PLX_9080_ENCODE(4, 0x84)
#define	GSC_PLX_9080_DMALADR0		GSC_PLX_9080_ENCODE(4, 0x88)
#define	GSC_PLX_9080_DMASIZ0		GSC_PLX_9080_ENCODE(4, 0x8C)
#define	GSC_PLX_9080_DMADPR0		GSC_PLX_9080_ENCODE(4, 0x90)
#define	GSC_PLX_9080_DMAMODE1		GSC_PLX_9080_ENCODE(4, 0x94)
#define	GSC_PLX_9080_DMAPADR1		GSC_PLX_9080_ENCODE(4, 0x98)
#define	GSC_PLX_9080_DMALADR1		GSC_PLX_9080_ENCODE(4, 0x9C)
#define	GSC_PLX_9080_DMASIZ1		GSC_PLX_9080_ENCODE(4, 0xA0)
#define	GSC_PLX_9080_DMADPR1		GSC_PLX_9080_ENCODE(4, 0xA4)
#define	GSC_PLX_9080_DMACSR0		GSC_PLX_9080_ENCODE(1, 0xA8)
#define	GSC_PLX_9080_DMACSR1		GSC_PLX_9080_ENCODE(1, 0xA9)
#define	GSC_PLX_9080_DMAARB			GSC_PLX_9080_ENCODE(4, 0xAC)
#define	GSC_PLX_9080_DMATHR			GSC_PLX_9080_ENCODE(4, 0xB0)

// PLX PCI9080 feature set registers: Messaging Queue Registers
#define	GSC_PLX_9080_OPLFIS			GSC_PLX_9080_ENCODE(4, 0x30)
#define	GSC_PLX_9080_OPLFIM			GSC_PLX_9080_ENCODE(4, 0x34)
#define	GSC_PLX_9080_IQP			GSC_PLX_9080_ENCODE(4, 0x40)
#define	GSC_PLX_9080_OQP			GSC_PLX_9080_ENCODE(4, 0x44)
#define	GSC_PLX_9080_MQCR			GSC_PLX_9080_ENCODE(4, 0xC0)
#define	GSC_PLX_9080_QBAR			GSC_PLX_9080_ENCODE(4, 0xC4)
#define	GSC_PLX_9080_IFHPR			GSC_PLX_9080_ENCODE(4, 0xC8)
#define	GSC_PLX_9080_IFTPR			GSC_PLX_9080_ENCODE(4, 0xCC)
#define	GSC_PLX_9080_IPHPR			GSC_PLX_9080_ENCODE(4, 0xD0)
#define	GSC_PLX_9080_IPTPR			GSC_PLX_9080_ENCODE(4, 0xD4)
#define	GSC_PLX_9080_OFHPR			GSC_PLX_9080_ENCODE(4, 0xD8)
#define	GSC_PLX_9080_OFTPR			GSC_PLX_9080_ENCODE(4, 0xDC)
#define	GSC_PLX_9080_OPHPR			GSC_PLX_9080_ENCODE(4, 0xE0)
#define	GSC_PLX_9080_OPTPR			GSC_PLX_9080_ENCODE(4, 0xE4)
#define	GSC_PLX_9080_QSR			GSC_PLX_9080_ENCODE(4, 0xE8)



#endif
