// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/include/16aics32_utils.h $
// $Rev: 56655 $
// $Date: 2025-09-19 11:03:26 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Utilities: header file

#ifndef	__16AICS32_UTILS_H__
#define	__16AICS32_UTILS_H__

#include "16aics32_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	aics32_close_util			(int fd, int index, int verbose);
int aics32_init_util			(int verbose);
int aics32_ioctl_util			(int fd, int index, int verbose, int request, void* arg);
int	aics32_open_util			(int device, int share, int index, int verbose, int* fd);
int	aics32_read_util			(int fd, int index, int verbose, void* dst, size_t bytes, size_t* got);

// IOCTL utility services

int	aics32_ai_buf_clear			(int fd, int index, int verbose);								// AICS32_IOCTL_AI_BUF_CLEAR
int	aics32_ai_buf_level			(int fd, int index, int verbose, s32* get);						// AICS32_IOCTL_AI_BUF_LEVEL
int	aics32_ai_buf_thr_lvl		(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_AI_BUF_THR_LVL
int	aics32_ai_buf_thr_sts		(int fd, int index, int verbose, s32* get);						// AICS32_IOCTL_AI_BUF_THR_STS
int	aics32_ai_clk_src			(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_AI_CLK_SRC
int	aics32_ai_mode				(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_AI_MODE
int	aics32_ai_range				(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_AI_RANGE
int	aics32_autocal				(int fd, int index, int verbose);								// AICS32_IOCTL_AUTOCAL
int	aics32_autocal_status		(int fd, int index, int verbose, s32* get);						// AICS32_IOCTL_AUTOCAL_STATUS
int	aics32_data_format			(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_DATA_FORMAT
int	aics32_excitation_mask_get	(int fd, int index, int verbose, s32* get);						// AICS32_IOCTL_EXCITATION_MASK_GET
int	aics32_excitation_mask_set	(int fd, int index, int verbose, s32 set);						// AICS32_IOCTL_EXCITATION_MASK_SET
int	aics32_excitation_test		(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_EXCITATION_TEST
int	aics32_ext_sync				(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_EXT_SYNC
int	aics32_initialize			(int fd, int index, int verbose);								// AICS32_IOCTL_INITIALIZE
int	aics32_input_sync			(int fd, int index, int verbose);								// AICS32_IOCTL_INPUT_SYNC
int	aics32_irq0_sel				(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_IRQ0_SEL
int	aics32_irq1_sel				(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_IRQ1_SEL
int	aics32_query				(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_QUERY
int	aics32_rag_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_RAG_ENABLE
int	aics32_rag_nrate			(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_RAG_NRATE
int	aics32_rbg_clk_src			(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_RBG_CLK_SRC
int	aics32_rbg_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_RBG_ENABLE
int	aics32_rbg_nrate			(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_RBG_NRATE
int	aics32_reg_mod				(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// AICS32_IOCTL_REG_MOD
int	aics32_reg_read				(int fd, int index, int verbose, u32 reg, u32* value);			// AICS32_IOCTL_REG_READ
int	aics32_reg_write			(int fd, int index, int verbose, u32 reg, u32 value);			// AICS32_IOCTL_REG_WRITE
int	aics32_rx_io_abort			(int fd, int index, int verbose, s32* get);						// AICS32_IOCTL_RX_IO_ABORT
int	aics32_rx_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_RX_IO_MODE
int	aics32_rx_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_RX_IO_TIMEOUT
int	aics32_scan_single			(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_SCAN_SINGLE
int	aics32_scan_size			(int fd, int index, int verbose, s32 set, s32* get);			// AICS32_IOCTL_SCAN_SIZE
int	aics32_wait_cancel			(int fd, int index, int verbose, gsc_wait_t* wait);				// AICS32_IOCTL_WAIT_CANCEL
int	aics32_wait_event			(int fd, int index, int verbose, gsc_wait_t* wait);				// AICS32_IOCTL_WAIT_EVENT
int	aics32_wait_status			(int fd, int index, int verbose, gsc_wait_t* wait);				// AICS32_IOCTL_WAIT_STATUS

// Auxiliary utility services

int	aics32_config_ai			(int fd, int index, int verbose, s32 size, s32 fsamp);
int	aics32_fsamp_ai_compute		(int fd, int index, int verbose, s32 fsamp, s32* src, s32* b_src, s32* nrate_a, s32* nrate_b, s32* enable_a, s32* enable_b, double* rate);
int	aics32_fsamp_ai_report		(int fd, int index, int verbose, int chan, s32* fsamp);
int	aics32_fsamp_ai_report_all	(int fd, int index, int verbose, s32* fsamp);
int	aics32_id_device			(int fd, int index, int verbose);

int	aics32_count_boards			(int verbose, s32* get);
int	aics32_reg_list				(int fd, int detail);

const gsc_reg_def_t*			aics32_reg_get_def_id		(u32 reg);
const gsc_reg_def_t*			aics32_reg_get_def_index	(int index);
const char*						aics32_reg_get_desc			(u32 reg);
const char*						aics32_reg_get_name			(u32 reg);

// Retained for backwards compatibility.
int	aics32_auto_calibrate		(int fd, int index, int verbose);
int	aics32_auto_cal_sts			(int fd, int index, int verbose, s32* get);


#endif
