// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/driver/16aics32.h $
// $Rev: 56668 $
// $Date: 2025-09-19 12:14:55 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Device Driver: header file

#ifndef	__16AICS32_H__
#define	__16AICS32_H__

#include "gsc_common.h"
#include "gsc_pci9080.h"



// macros *********************************************************************

#define	AICS32_BASE_NAME					"16aics32"

// IOCTL command codes
#define	AICS32_IOCTL_REG_READ				OS_IOCTL_RW( 0, 12, gsc_reg_t)
#define	AICS32_IOCTL_REG_WRITE				OS_IOCTL_W ( 1, 12, gsc_reg_t)
#define	AICS32_IOCTL_REG_MOD				OS_IOCTL_W ( 2, 12, gsc_reg_t)
#define	AICS32_IOCTL_QUERY					OS_IOCTL_RW( 3,  4, s32)
#define	AICS32_IOCTL_INITIALIZE				OS_IOCTL   ( 4)
#define	AICS32_IOCTL_AUTOCAL				OS_IOCTL   ( 5)
#define	AICS32_IOCTL_AUTOCAL_STATUS			OS_IOCTL_R ( 6,  4, s32)
#define	AICS32_IOCTL_AI_BUF_CLEAR			OS_IOCTL   ( 7)
#define	AICS32_IOCTL_AI_BUF_LEVEL			OS_IOCTL_R ( 8,  4, s32)
#define	AICS32_IOCTL_AI_BUF_THR_LVL			OS_IOCTL_RW( 9,  4, s32)
#define	AICS32_IOCTL_AI_BUF_THR_STS			OS_IOCTL_R (10,  4, s32)
#define	AICS32_IOCTL_AI_CLK_SRC				OS_IOCTL_RW(11,  4, s32)
#define	AICS32_IOCTL_AI_MODE				OS_IOCTL_RW(12,  4, s32)
#define	AICS32_IOCTL_AI_RANGE				OS_IOCTL_RW(13,  4, s32)
#define	AICS32_IOCTL_DATA_FORMAT			OS_IOCTL_RW(14,  4, s32)
#define	AICS32_IOCTL_EXCITATION_MASK_GET	OS_IOCTL_R (15,  4, u32)
#define	AICS32_IOCTL_EXCITATION_MASK_SET	OS_IOCTL_W (16,  4, u32)
#define	AICS32_IOCTL_EXCITATION_TEST		OS_IOCTL_RW(17,  4, s32)
#define	AICS32_IOCTL_EXT_SYNC				OS_IOCTL_RW(18,  4, s32)
#define	AICS32_IOCTL_INPUT_SYNC				OS_IOCTL   (19)
#define	AICS32_IOCTL_IRQ0_SEL				OS_IOCTL_RW(20,  4, s32)
#define	AICS32_IOCTL_IRQ1_SEL				OS_IOCTL_RW(21,  4, s32)
#define	AICS32_IOCTL_RAG_ENABLE				OS_IOCTL_RW(22,  4, s32)
#define	AICS32_IOCTL_RAG_NRATE				OS_IOCTL_RW(23,  4, s32)
#define	AICS32_IOCTL_RBG_CLK_SRC			OS_IOCTL_RW(24,  4, s32)
#define	AICS32_IOCTL_RBG_ENABLE				OS_IOCTL_RW(25,  4, s32)
#define	AICS32_IOCTL_RBG_NRATE				OS_IOCTL_RW(26,  4, s32)
#define	AICS32_IOCTL_RX_IO_ABORT			OS_IOCTL_R (27,  4, s32)
#define	AICS32_IOCTL_RX_IO_MODE				OS_IOCTL_RW(28,  4, s32)
#define	AICS32_IOCTL_RX_IO_TIMEOUT			OS_IOCTL_RW(29,  4, s32)
#define	AICS32_IOCTL_SCAN_SINGLE			OS_IOCTL_RW(30,  4, s32)
#define	AICS32_IOCTL_SCAN_SIZE				OS_IOCTL_RW(31,  4, s32)
#define	AICS32_IOCTL_WAIT_CANCEL			OS_IOCTL_RW(32, 28, gsc_wait_t)
#define	AICS32_IOCTL_WAIT_EVENT				OS_IOCTL_RW(33, 28, gsc_wait_t)
#define	AICS32_IOCTL_WAIT_STATUS			OS_IOCTL_RW(34, 28, gsc_wait_t)

// Retained for backwards compatibility
#define	AICS32_IOCTL_AUTO_CALIBRATE			AICS32_IOCTL_AUTOCAL
#define	AICS32_IOCTL_AUTO_CAL_STS			AICS32_IOCTL_AUTOCAL_STATUS

//*****************************************************************************
// AICS32_IOCTL_REG_READ
// AICS32_IOCTL_REG_WRITE
// AICS32_IOCTL_REG_MOD
//
#define	AICS32_REG_ENCODE(s,o)				GSC_REG_ENCODE(GSC_REG_TYPE_BAR2,(s),(o))
// Parameter:	gsc_reg_t*
#define	AICS32_GSC_BCTLR					AICS32_REG_ENCODE(4,0x00)// Board Control Register
#define	AICS32_GSC_ICR						AICS32_REG_ENCODE(4,0x04)// Interrupt Control Register
#define	AICS32_GSC_IBDR						AICS32_REG_ENCODE(4,0x08)// Input Buffer Data Register
#define	AICS32_GSC_IBCR						AICS32_REG_ENCODE(4,0x0C)// Input Buffer Control Register
#define	AICS32_GSC_RAGR						AICS32_REG_ENCODE(4,0x10)// Rate-A Generator Register
#define	AICS32_GSC_RBGR						AICS32_REG_ENCODE(4,0x14)// Rate-B Generator Register
#define	AICS32_GSC_BSIZR					AICS32_REG_ENCODE(4,0x18)// Buffer Size Register
#define	AICS32_GSC_SSCR						AICS32_REG_ENCODE(4,0x20)// Scan & Sync Control Register
#define	AICS32_GSC_BCFGR					AICS32_REG_ENCODE(4,0x28)// Board Configuration Register
#define	AICS32_GSC_AVR						AICS32_REG_ENCODE(4,0x2C)// Auto Cal Values Register
#define	AICS32_GSC_EM00R					AICS32_REG_ENCODE(4,0x30)// Excitation Mask 00-15 Register
#define	AICS32_GSC_EM16R					AICS32_REG_ENCODE(4,0x34)// Excitation Mask 16-31 Register

//*****************************************************************************
// AICS32_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		The value returned is the answer to the query.

typedef enum
{
	AICS32_QUERY_AUTOCAL_MS,	// Max autocalibrate period in ms.
	AICS32_QUERY_CHANNEL_MAX,	// Maximum number of channels supported (differential).
	AICS32_QUERY_CHANNEL_QTY,	// The number of channels on the device (differential).
	AICS32_QUERY_DEVICE_TYPE,	// Value from gsc_dev_type_t
	AICS32_QUERY_EXCITATION,	// Excitation Current - THIS DEVICE QUERY OPTION IS INACTIVE
	AICS32_QUERY_FGEN_MAX,		// Rate Generator maximum output rate.
	AICS32_QUERY_FGEN_MIN,		// Rate Generator minimum output rate.
	AICS32_QUERY_FIFO_SIZE,		// FIFO depth in 32-bit samples
	AICS32_QUERY_FSAMP_MAX,		// The maximum sample rate per channel.
	AICS32_QUERY_FSAMP_MIN,		// The minimum sample rate per channel.
	AICS32_QUERY_INIT_MS,		// Max initialize period in ms.
	AICS32_QUERY_MASTER_CLOCK,	// Master clock frequency
	AICS32_QUERY_NRATE_MAX,		// Maximum rate generator Nrate value.
	AICS32_QUERY_NRATE_MIN,		// Maximum rate generator Nrate value.
	AICS32_QUERY_RATE_GEN_QTY,	// Number of Rate Generatorts.

	AICS32_QUERY_COUNT	// MUST BE LAST! How many query options are supported?
} aics32_query_t;

// Retained for backwards compatibility.
#define	AICS32_QUERY_AUTO_CAL_MS	AICS32_QUERY_AUTOCAL_MS

#define	AICS32_IOCTL_QUERY_ERROR			(-1)

// AICS32_QUERY_EXCITATION options
#define	AICS32_QUERY_EXCITATION_1_0_MA		0
#define	AICS32_QUERY_EXCITATION_2_0_MA		1
#define	AICS32_QUERY_EXCITATION_3_0_MA		2
#define	AICS32_QUERY_EXCITATION_5_0_MA		3
#define	AICS32_QUERY_EXCITATION_0_4_MA		4
#define	AICS32_QUERY_EXCITATION_10_0_MA		5

//*****************************************************************************
// AICS32_IOCTL_INITIALIZE					BCTLR D15
//
//	Parameter:	None

//*****************************************************************************
// AICS32_IOCTL_AUTOCAL						BCTLR D13
//
//	Parameter:	None

//*****************************************************************************
// AICS32_IOCTL_AUTOCAL_STATUS				BCR D13, D14
//
//	Parameter:	s32*
//		One of the below values is returned.
#define	AICS32_AUTOCAL_STATUS_ACTIVE		0
#define	AICS32_AUTOCAL_STATUS_FAIL			1
#define	AICS32_AUTOCAL_STATUS_PASS			2

// Retained for backwards compatibility.
#define	AICS32_AUTO_CAL_STS_ACTIVE			AICS32_AUTOCAL_STATUS_ACTIVE
#define	AICS32_AUTO_CAL_STS_FAIL			AICS32_AUTOCAL_STATUS_FAIL
#define	AICS32_AUTO_CAL_STS_PASS			AICS32_AUTOCAL_STATUS_PASS

//*****************************************************************************
// AICS32_IOCTL_AI_BUF_CLEAR				IBCR D16
//
//	Parameter:	None.

//*****************************************************************************
// AICS32_IOCTL_AI_BUF_LEVEL				BSIZR D0-D15
//
//	Parameter:	s32*
//		The value returned is the current input buffer fill level.

//*****************************************************************************
// AICS32_IOCTL_AI_BUF_THR_LVL				IBCR D0-D15
//
//	Parameter:	s32*
//		Pass in any valid value from 0x0 to 0xFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AICS32_IOCTL_AI_BUF_THR_STS				IBCR D17
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AICS32_AI_BUF_THR_STS_CLEAR			0
#define	AICS32_AI_BUF_THR_STS_SET			1

//*****************************************************************************
// AICS32_IOCTL_AI_CLK_SRC					SSCR D3-D4
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_AI_CLK_SRC_RAG				0
#define	AICS32_AI_CLK_SRC_RBG				1
#define	AICS32_AI_CLK_SRC_EXT				2
#define	AICS32_AI_CLK_SRC_BCR				3

//*****************************************************************************
// AICS32_IOCTL_AI_MODE						BCTLR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_AI_MODE_DIFF					0	// Differential
#define	AICS32_AI_MODE_SE					1	// Single Ended
#define	AICS32_AI_MODE_ZERO					2	// Zero test
#define	AICS32_AI_MODE_VREF					3	// Vref test

//*****************************************************************************
// AICS32_IOCTL_AI_RANGE					BCTLR D4-D5
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_AI_RANGE_2_5V				0	// +- 2.5 volts
#define	AICS32_AI_RANGE_5V					1	// +- 5 volts
#define	AICS32_AI_RANGE_10V					2	// +- 10 volts

//*****************************************************************************
// AICS32_IOCTL_DATA_FORMAT					BCTLR D6
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_DATA_FORMAT_2S_COMP			0	// Twos Compliment
#define	AICS32_DATA_FORMAT_OFF_BIN			1	// Offset Binary

//*****************************************************************************
// AICS32_IOCTL_EXCITATION_MASK_GET			EM00R D0-D15 L, EM15R D0-D15 H
// AICS32_IOCTL_EXCITATION_MASK_SET			EM00R D0-D15 L, EM15R D0-D15 H
//
//	Parameter:	s32*
//		The set option accepts any value from 0x0 to 0xFFFFFFFF.
//		The get option returns the current setting.

//*****************************************************************************
// AICS32_IOCTL_EXCITATION_TEST				BCTLR D8
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_EXCITATION_TEST_OFF			0
#define	AICS32_EXCITATION_TEST_ON			1

//*****************************************************************************
// AICS32_IOCTL_EXT_SYNC					BCTLR D7
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_EXT_SYNC_DISABLE				0
#define	AICS32_EXT_SYNC_ENABLE				1

//*****************************************************************************
// AICS32_IOCTL_INPUT_SYNC					BCTLR D12
//
//	Parameter:	None.

//*****************************************************************************
// AICS32_IOCTL_IRQ0_SEL					ICR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_IRQ0_INIT_DONE				0
#define	AICS32_IRQ0_AUTOCAL_DONE			1
#define	AICS32_IRQ0_SCAN_START				2
#define	AICS32_IRQ0_SCAN_DONE				3

// Retained for backwards compatibility
#define	AICS32_IRQ0_AUTO_CAL_DONE			AICS32_IRQ0_AUTOCAL_DONE

//*****************************************************************************
// AICS32_IOCTL_IRQ1_SEL					ICR D4-D6
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_IRQ1_NONE					0
#define	AICS32_IRQ1_IN_BUF_THR_L2H			1
#define	AICS32_IRQ1_IN_BUF_THR_H2L			2

//*****************************************************************************
// AICS32_IOCTL_RAG_ENABLE					RAGR D16
// AICS32_IOCTL_RBG_ENABLE					RBGR D16
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_GEN_ENABLE_NO				1
#define	AICS32_GEN_ENABLE_YES				0

//*****************************************************************************
// AICS32_IOCTL_RAG_NRATE					RAGR D0-D15
// AICS32_IOCTL_RBG_NRATE					RBGR D0-D15
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current setting.
//		At this time the valid range is 240-0xFFFF.

//*****************************************************************************
// AICS32_IOCTL_RBG_CLK_SRC					SSCR D10
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_RBG_CLK_SRC_MASTER			0
#define	AICS32_RBG_CLK_SRC_RAG				1

//*****************************************************************************
// AICS32_IOCTL_RX_IO_ABORT
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AICS32_IO_ABORT_NO					0
#define	AICS32_IO_ABORT_YES					1

//*****************************************************************************
// AICS32_IOCTL_RX_IO_MODE
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
#define	AICS32_IO_MODE_DEFAULT				GSC_IO_MODE_PIO
// GSC_IO_MODE_PIO
// GSC_IO_MODE_BMDMA

//*****************************************************************************
// AICS32_IOCTL_RX_IO_TIMEOUT (in seconds)
//
//	Parameter:	s32*
//		Pass in any value from the minimim to the maximim, the infinite option,
//		or -1 to read the current setting. The value -1 is returned if the
//		feature is not supported, but this should never happen.
#define	AICS32_IO_TIMEOUT_DEFAULT			10
#define	AICS32_IO_TIMEOUT_NO_SLEEP			0
#define	AICS32_IO_TIMEOUT_MIN				0
#define	AICS32_IO_TIMEOUT_MAX				GSC_IO_TIMEOUT_MAX
#define	AICS32_IO_TIMEOUT_INFINITE			GSC_IO_TIMEOUT_INFINITE

//*****************************************************************************
// AICS32_IOCTL_SCAN_SINGLE					SSCR D12-D17
//
//	Parameter:	s32*
//		Pass in any valid value from zero to the index of the last channel, or
//		-1 to read the current setting.

//*****************************************************************************
// AICS32_IOCTL_SCAN_SIZE					SSCR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AICS32_SCAN_SIZE_SINGLE				0
#define	AICS32_SCAN_SIZE_0_1				1
#define	AICS32_SCAN_SIZE_0_3				2
#define	AICS32_SCAN_SIZE_0_7				3
#define	AICS32_SCAN_SIZE_0_15				4
#define	AICS32_SCAN_SIZE_0_31				5
#define	AICS32_SCAN_SIZE_0_63				6	// Single Ended mode only

//*****************************************************************************
// AICS32_IOCTL_WAIT_EVENT					all fields must be valid
// AICS32_IOCTL_WAIT_CANCEL					fields need not be valid
// AICS32_IOCTL_WAIT_STATUS					fields need not be valid
//
//	Parameter:	gsc_wait_t*
// gsc_wait_t.flags - see gsc_common.h
// gsc_wait_t.main - see gsc_common.h
// gsc_wait_t.gsc
#define	AICS32_WAIT_GSC_INIT_DONE			0x0001
#define	AICS32_WAIT_GSC_AUTOCAL_DONE		0x0002
#define	AICS32_WAIT_GSC_SCAN_START			0x0003
#define	AICS32_WAIT_GSC_SCAN_DONE			0x0004
#define	AICS32_WAIT_GSC_IN_BUF_THR_L2H		0x0010
#define	AICS32_WAIT_GSC_IN_BUF_THR_H2L		0x0020
#define	AICS32_WAIT_GSC_ALL					0x003F
// gsc_wait_t.alt flags
#define	AICS32_WAIT_ALT_ALL					0x0000
// gsc_wait_t.io
#define	AICS32_WAIT_IO_RX_ABORT				0x0001
#define	AICS32_WAIT_IO_RX_DONE				0x0002
#define	AICS32_WAIT_IO_RX_ERROR				0x0004
#define	AICS32_WAIT_IO_RX_TIMEOUT			0x0008
#define	AICS32_WAIT_IO_ALL					0x000F

// Retained for backwards compatibility.
#define	AICS32_WAIT_GSC_AUTO_CAL_DONE		AICS32_WAIT_GSC_AUTOCAL_DONE



#endif
