// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/driver/irq.c $
// $Rev: 56668 $
// $Date: 2025-09-19 12:14:55 -0500 (Fri, 19 Sep 2025) $

// 16AICS32: Device Driver: source file

#include "main.h"



//*****************************************************************************
void dev_irq_isr_local_handler(dev_data_t* dev)
{
	#define	ICR_IRQ0_REQUEST	0x08
	#define	ICR_IRQ1_REQUEST	0x80

	u32	icr;
	u32	irq;

	icr	= os_reg_mem_rx_u32(NULL, dev->vaddr.gsc_icr_32);

	if (icr & ICR_IRQ0_REQUEST)
	{
		// Clear the interrupt.

		if ((dev->cache.gsc_bcfgr_32 & 0xFFF) <= 0x002)
			icr	= icr & ~(ICR_IRQ0_REQUEST | ICR_IRQ1_REQUEST);
		else
			icr	= (icr & ~ICR_IRQ0_REQUEST) | ICR_IRQ1_REQUEST;

		os_reg_mem_tx_u32(NULL, dev->vaddr.gsc_icr_32, icr);

		// Resume any blocked threads.
		irq	= GSC_FIELD_DECODE(icr, 2, 0);

		switch (irq)
		{
			default:

				gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
				break;

			case AICS32_IRQ0_INIT_DONE:

				gsc_wait_resume_irq_gsc(dev, AICS32_WAIT_GSC_INIT_DONE);
				break;

			case AICS32_IRQ0_AUTOCAL_DONE:

				gsc_wait_resume_irq_gsc(dev, AICS32_WAIT_GSC_AUTOCAL_DONE);
				break;

			case AICS32_IRQ0_SCAN_START:

				gsc_wait_resume_irq_gsc(dev, AICS32_WAIT_GSC_SCAN_START);
				break;

			case AICS32_IRQ0_SCAN_DONE:

				gsc_wait_resume_irq_gsc(dev, AICS32_WAIT_GSC_SCAN_DONE);
				break;
		}
	}
	else if (icr & ICR_IRQ1_REQUEST)
	{
		// Clear the interrupt.

		if ((dev->cache.gsc_bcfgr_32 & 0xFFF) <= 0x002)
			icr	= icr & ~(ICR_IRQ0_REQUEST | ICR_IRQ1_REQUEST);
		else
			icr	= (icr & ~ICR_IRQ1_REQUEST) | ICR_IRQ0_REQUEST;

		os_reg_mem_tx_u32(NULL, dev->vaddr.gsc_icr_32, icr);

		// Resume any blocked threads.
		irq	= GSC_FIELD_DECODE(icr, 6, 4);

		switch (irq)
		{
			default:

				gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
				break;

			case AICS32_IRQ1_IN_BUF_THR_L2H:

				gsc_wait_resume_irq_gsc(dev, AICS32_WAIT_GSC_IN_BUF_THR_L2H);
				break;

			case AICS32_IRQ1_IN_BUF_THR_H2L:

				gsc_wait_resume_irq_gsc(dev, AICS32_WAIT_GSC_IN_BUF_THR_H2L);
				break;
		}
	}
	else
	{
		// We don't know the source of the interrupt.
		gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
	}
}



//*****************************************************************************
int dev_irq_create(dev_data_t* dev)
{
	int	ret;

	os_reg_mem_tx_u32(dev, dev->vaddr.gsc_icr_32, 0);
	ret	= gsc_irq_create(dev);
	return(ret);
}



//*****************************************************************************
void dev_irq_destroy(dev_data_t* dev)
{
	if (dev->vaddr.gsc_icr_32)
		os_reg_mem_tx_u32(dev, dev->vaddr.gsc_icr_32, 0);

	gsc_irq_destroy(dev);
}


