// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AICS32/api/read.c $
// $Rev: 44852 $
// $Date: 2019-05-10 15:31:19 -0500 (Fri, 10 May 2019) $

// 16AICS32: API Library: source file

#include "main.h"



//*****************************************************************************
// Return Values:
//	>=0	= success, the number of bytes transferred
//	<0  = failure, value is -errno or -GetLastError (Windows only)
int aics32_read(int fd, void* dst, size_t bytes)
{
	int	ret;

	if (bytes > GSC_IO_SIZE_QTY_MASK)
		bytes	= GSC_IO_SIZE_QTY_MASK & ~0x3;

	bytes	|= STREAM_ID_RX;
	ret		= gsc_api_read(fd, dst, bytes);
	return(ret);
}


