// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64SSA/include/16ai64ssa_utils.h $
// $Rev: 53565 $
// $Date: 2023-08-07 16:23:55 -0500 (Mon, 07 Aug 2023) $

// 16AI64SSA: Utilities: header file

#ifndef	__16AI64SSA_UTILS_H__
#define	__16AI64SSA_UTILS_H__

#include "16ai64ssa_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	ai64ssa_close_util			(int fd, int index, int verbose);
int ai64ssa_init_util			(int verbose);
int ai64ssa_ioctl_util			(int fd, int index, int verbose, int request, void* arg);
int	ai64ssa_open_util			(int device, int share, int index, int verbose, int* fd);
int	ai64ssa_read_util			(int fd, int index, int verbose, void* dst, size_t bytes, size_t* got);

// IOCTL utility services

int	ai64ssa_ai_buf_clear		(int fd, int index, int verbose);								// AI64SSA_IOCTL_AI_BUF_CLEAR
int	ai64ssa_ai_buf_level		(int fd, int index, int verbose, s32* get);						// AI64SSA_IOCTL_AI_BUF_LEVEL
int	ai64ssa_ai_buf_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AI_BUF_OVERFLOW
int	ai64ssa_ai_buf_thr_lvl		(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AI_BUF_THR_LVL
int	ai64ssa_ai_buf_thr_sts		(int fd, int index, int verbose, s32* get);						// AI64SSA_IOCTL_AI_BUF_THR_STS
int	ai64ssa_ai_buf_underflow	(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AI_BUF_UNDERFLOW
int	ai64ssa_ai_mode				(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AI_MODE
int	ai64ssa_ai_range			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AI_RANGE
int	ai64ssa_autocal				(int fd, int index, int verbose);								// AI64SSA_IOCTL_AUTOCAL
int	ai64ssa_autocal_status		(int fd, int index, int verbose, s32* get);						// AI64SSA_IOCTL_AUTOCAL_STATUS
int	ai64ssa_aux_0_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AUX_0_MODE
int	ai64ssa_aux_1_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AUX_1_MODE
int	ai64ssa_aux_2_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AUX_2_MODE
int	ai64ssa_aux_3_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AUX_3_MODE
int	ai64ssa_aux_in_pol			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AUX_IN_POL
int	ai64ssa_aux_noise			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AUX_NOISE
int	ai64ssa_aux_out_pol			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_AUX_OUT_POL
int	ai64ssa_burst_size			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_BURST_SIZE
int	ai64ssa_burst_src			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_BURST_SRC
int	ai64ssa_burst_status		(int fd, int index, int verbose, s32* get);						// AI64SSA_IOCTL_BURST_STATUS
int	ai64ssa_chan_active			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_CHAN_ACTIVE
int	ai64ssa_chan_first			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_CHAN_FIRST
int	ai64ssa_chan_last			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_CHAN_LAST
int	ai64ssa_chan_single			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_CHAN_SINGLE
int	ai64ssa_data_format			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_DATA_FORMAT
int	ai64ssa_data_packing		(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_DATA_PACKING
int	ai64ssa_ext_sync_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_EXT_SYNC_ENABLE
int	ai64ssa_initialize			(int fd, int index, int verbose);								// AI64SSA_IOCTL_INITIALIZE
int	ai64ssa_input_sync			(int fd, int index, int verbose);								// AI64SSA_IOCTL_INPUT_SYNC
int	ai64ssa_irq0_sel			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_IRQ0_SEL
int	ai64ssa_irq1_sel			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_IRQ1_SEL
int	ai64ssa_low_lat_doh			(int fd, int index, int verbose, s32* get);						// AI64SSA_IOCTL_LOW_LAT_DOH
int	ai64ssa_low_lat_hold_chan	(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_LOW_LAT_HOLD_CHAN
int	ai64ssa_low_lat_read		(int fd, int index, int verbose, ai64ssa_ll_t* get);			// AI64SSA_IOCTL_LOW_LAT_READ
int	ai64ssa_low_lat_rel_chan	(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_LOW_LAT_REL_CHAN
int	ai64ssa_query				(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_QUERY
int	ai64ssa_rag_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_RAG_ENABLE
int	ai64ssa_rag_nrate			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_RAG_NRATE
int	ai64ssa_rbg_clk_src			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_RBG_CLK_SRC
int	ai64ssa_rbg_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_RBG_ENABLE
int	ai64ssa_rbg_nrate			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_RBG_NRATE
int	ai64ssa_reg_mod				(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// AI64SSA_IOCTL_REG_MOD
int	ai64ssa_reg_read			(int fd, int index, int verbose, u32 reg, u32* value);			// AI64SSA_IOCTL_REG_READ
int	ai64ssa_reg_write			(int fd, int index, int verbose, u32 reg, u32 value);			// AI64SSA_IOCTL_REG_WRITE
int	ai64ssa_rx_io_abort			(int fd, int index, int verbose, s32* get);						// AI64SSA_IOCTL_RX_IO_ABORT
int	ai64ssa_rx_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_RX_IO_MODE
int	ai64ssa_rx_io_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_RX_IO_OVERFLOW
int	ai64ssa_rx_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_RX_IO_TIMEOUT
int	ai64ssa_rx_io_underflow		(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_RX_IO_UNDERFLOW
int	ai64ssa_samp_clk_src		(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_SAMP_CLK_SRC
int	ai64ssa_scan_marker			(int fd, int index, int verbose, s32 set, s32* get);			// AI64SSA_IOCTL_SCAN_MARKER
int	ai64ssa_scan_marker_get		(int fd, int index, int verbose, u32* get);						// AI64SSA_IOCTL_SCAN_MARKER_GET
int	ai64ssa_scan_marker_set		(int fd, int index, int verbose, u32 set);						// AI64SSA_IOCTL_SCAN_MARKER_SET
int	ai64ssa_wait_cancel			(int fd, int index, int verbose, gsc_wait_t* wait);				// AI64SSA_IOCTL_WAIT_CANCEL
int	ai64ssa_wait_event			(int fd, int index, int verbose, gsc_wait_t* wait);				// AI64SSA_IOCTL_WAIT_EVENT
int	ai64ssa_wait_status			(int fd, int index, int verbose, gsc_wait_t* wait);				// AI64SSA_IOCTL_WAIT_STATUS

// Auxiliary utility services

int	ai64ssa_config_ai			(int fd, int index, int verbose, s32 fsamp);
int	ai64ssa_config_aux			(int fd, int index, int verbose);
int	ai64ssa_fsamp_ai_compute	(int fd, int index, int verbose, s32 fsamp, s32* src, s32* src_b, s32* nrate_a, s32* nrate_b, s32* enable_a, s32* enable_b, double* rate);
int ai64ssa_fsamp_ai_report		(int fd, int index, int verbose, int chan, s32* fsamp);
int ai64ssa_fsamp_ai_report_all	(int fd, int index, int verbose, s32* fsamp);
int	ai64ssa_id_device			(int fd, int index, int verbose);

int	ai64ssa_count_boards		(int verbose, s32* get);
int	ai64ssa_reg_list			(int fd, int detail);

const gsc_reg_def_t*			ai64ssa_reg_get_def_id(u32 reg);
const gsc_reg_def_t*			ai64ssa_reg_get_def_index(int index);
const char*						ai64ssa_reg_get_desc(u32 reg);
const char*						ai64ssa_reg_get_name(u32 reg);

// Retained for backwards compatibility:
int	ai64ssa_auto_cal_sts		(int fd, int index, int verbose, s32* get);
int	ai64ssa_auto_calibrate		(int fd, int index, int verbose);


#endif
