// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/utils/rx_io_timeout.c $
// $Rev: 55142 $
// $Date: 2024-08-30 10:26:38 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai64_rx_io_timeout
*
*	Purpose:
*
*		Provide a visual wrapper for the AI64_IOCTL_RX_IO_TIMEOUT service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		set		The setting to apply.
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai64_rx_io_timeout(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("Rx I/O Timeout", index);

	ret		= ai64_ioctl(fd, AI64_IOCTL_RX_IO_TIMEOUT, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
	{
		if (set == -1)
		{
			ptr	= "This service is not supported by this device.";
		}
		else if (set == AI64_IO_TIMEOUT_INFINITE)
		{
			ptr	= "infinite/never timeout";
		}
		else
		{
			sprintf(buf, "%ld second%s", (long) set, (set == 1) ? "" : "s");
			ptr	= buf;
		}

		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);
	}

	if (get)
		get[0]	= set;

	return(errs);
}


