// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/utils/reset_inputs.c $
// $Rev: 55142 $
// $Date: 2024-08-30 10:26:38 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai64_reset_inputs
*
*	Purpose:
*
*		Provide a visual wrapper for the AI64_IOCTL_RESET_INPUTS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai64_reset_inputs(int fd, int index, int verbose)
{
	int	errs;
	s32	ll;
	int	ret;

	if (verbose)
		gsc_label_index("AI Buffer Clear", index);

	errs	= ai64_query(fd, -1, 0, AI64_QUERY_LOW_LATENCY, &ll);
	ret		= ai64_ioctl(fd, AI64_IOCTL_RESET_INPUTS, NULL);
	errs	+= ret ? 1 : 0;

	if (verbose)
	{
		printf(	"%s%s\n",
				errs ? "FAIL <---" : "PASS",
				ll ? "" : "  (Feature Not Supported)");
	}

	return(errs);
}


