// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/utils/low_lat_read.c $
// $Rev: 55142 $
// $Date: 2024-08-30 10:26:38 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai64_low_lat_read
*
*	Purpose:
*
*		Provide a visual wrapper for the AI64_IOCTL_LOW_LAT_READ service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		get		The values read go here.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai64_low_lat_read(int fd, int index, int verbose, ai64_ll_t* get)
{
	ai64_ll_t	arg;
	char		buf[128];
	int			errs;
	int			ret;

	if (verbose)
		gsc_label_index("Low Latency Read", index);

	ret		= ai64_ioctl(fd, AI64_IOCTL_LOW_LAT_READ, &arg);
	errs	= ret ? 1 : 0;

	if (verbose)
	{
		if (arg.ret == -1)
			strcpy(buf, "  (Feature Not Supported)");
		else
			buf[0]	= 0;

		printf("%s%s\n", errs ? "FAIL <---" : "PASS", buf);
	}

	if (get)
		get[0]	= arg;

	return(errs);
}


