// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/utils/config_ai.c $
// $Rev: 55142 $
// $Date: 2024-08-30 10:26:38 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai64_config_ai
*
*	Purpose:
*
*		Configure the given device's analog input options.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		scan_size	The scan size setting to use.
*
*		fsamp		The desired sample rate value.
*
*	Returned:
*
*		>= 0		The number of errors encounterred.
*
******************************************************************************/

int	ai64_config_ai(int fd, int index, int verbose, s32 scan_size, s32 fsamp)
{
	s32	enable_a;
	s32	enable_b;
	int	errs		= 0;
	s32	nrate_a;
	s32	nrate_b;
	s32	src;
	s32	src_b;

	if (verbose)
	{
		gsc_label_index("Input Configuration", index);
		printf("\n");
		gsc_label_level_inc();
	}

	errs	+= ai64_initialize			(fd, index, verbose);

	// Settings must be applied after the initialization call!

	errs	+= ai64_rx_io_mode			(fd, index, verbose, GSC_IO_MODE_PIO,			NULL);
	errs	+= ai64_rx_io_timeout		(fd, index, verbose, AI64_IO_TIMEOUT_DEFAULT,	NULL);
	errs	+= ai64_ai_range			(fd, index, verbose, AI64_AI_RANGE_10V,			NULL);
	errs	+= ai64_ai_buf_thr_lvl		(fd, index, verbose, 64000,						NULL);
	errs	+= ai64_ai_mode				(fd, index, verbose, AI64_AI_MODE_SINGLE,		NULL);
	errs	+= ai64_ai_scan_size		(fd, index, verbose, scan_size,					NULL);
	errs	+= ai64_chan_single			(fd, index, verbose, 0,							NULL);
	errs	+= ai64_data_format			(fd, index, verbose, AI64_DATA_FORMAT_OFF_BIN,	NULL);
	errs	+= ai64_ext_sync_enable		(fd, index, verbose, AI64_EXT_SYNC_ENABLE_NO,	NULL);
	errs	+= ai64_fsamp_ai_compute	(fd, index, verbose, fsamp, &src, &src_b, &nrate_a, &nrate_b, &enable_a, &enable_b, NULL);
	errs	+= ai64_ai_clk_src			(fd, index, verbose, src,						NULL);
	errs	+= ai64_rbg_clk_src			(fd, index, verbose, src_b,						NULL);
	errs	+= ai64_rag_nrate			(fd, index, verbose, nrate_a,					NULL);
	errs	+= ai64_rbg_nrate			(fd, index, verbose, nrate_b,					NULL);
	errs	+= ai64_rag_enable			(fd, index, verbose, enable_a,					NULL);
	errs	+= ai64_rbg_enable			(fd, index, verbose, enable_b,					NULL);
	errs	+= ai64_conv_counter		(fd, index, verbose, 0,							NULL);
	errs	+= ai64_scan_enable			(fd, index, verbose, AI64_SCAN_ENABLE_YES,		NULL);

	errs	+= ai64_fsamp_ai_report_all	(fd, index, verbose,							NULL);

	// Settings affecting the sample rate or voltage range must generally
	// be applied before autocalibration.
	// Refer to the board user manual for clarification.
	errs	+= ai64_autocal				(fd, index, verbose);	// Cable may need disconnecting for this.

	// Interrupt selections should be applied after autocalibration as the
	// driver overwrites the current selection to detect the Autocalibration
	// Done interrupt. If an application intends to detect the Autocalibration
	// Done interrupt, then the interrupt selection may be made beforehand.
	errs	+= ai64_irq0_sel			(fd, index, verbose, AI64_IRQ0_INIT_DONE,		NULL);
	errs	+= ai64_irq1_sel			(fd, index, verbose, AI64_IRQ1_NONE,			NULL);

	// The final step is to clear the buffer.
	errs	+= ai64_ai_buf_clear		(fd, index, verbose);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


