// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/utils/ai_scan_size.c $
// $Rev: 55142 $
// $Date: 2024-08-30 10:26:38 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai64_ai_scan_size
*
*	Purpose:
*
*		Provide a visual wrapper for the AI64_IOCTL_AI_SCAN_SIZE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai64_ai_scan_size(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("AI Scan Size", index);

	ret		= ai64_ioctl(fd, AI64_IOCTL_AI_SCAN_SIZE, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "Feature Not Supported";
			break;

		case AI64_AI_SCAN_SIZE_SINGLE:

			ptr	= "Single Channel";
			break;

		case AI64_AI_SCAN_SIZE_0_1:

			ptr	= "Channels 0 through 1";
			break;

		case AI64_AI_SCAN_SIZE_0_3:

			ptr	= "Channels 0 through 3";
			break;

		case AI64_AI_SCAN_SIZE_0_7:

			ptr	= "Channels 0 through 7";
			break;

		case AI64_AI_SCAN_SIZE_0_15:

			ptr	= "Channels 0 through 15";
			break;

		case AI64_AI_SCAN_SIZE_0_31:

			ptr	= "Channels 0 through 31";
			break;

		case AI64_AI_SCAN_SIZE_0_63:

			ptr	= "Channels 0 through 63";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


