// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/utils/ai_buf_level.c $
// $Rev: 55142 $
// $Date: 2024-08-30 10:26:38 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai64_ai_buf_level
*
*	Purpose:
*
*		Provide a visual wrapper for the AI64_IOCTL_AI_BUF_LEVEL service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai64_ai_buf_level(int fd, int index, int verbose, s32* get)
{
	int	errs;
	int	ret;
	s32	set;

	if (verbose)
		gsc_label_index("AI Buffer Level", index);

	ret		= ai64_ioctl(fd, AI64_IOCTL_AI_BUF_LEVEL, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s  (0x%lX)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


