// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/samples/signals/perform.c $
// $Rev: 55150 $
// $Date: 2024-08-30 10:35:03 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	char	buf[64];
	int		errs	= 0;
	s32		fref;
	s32		ll;
	s32		nrate;
	s32		sps;

	//===============================================================
	gsc_label("Setup");
	printf("\n");
	gsc_label_level_inc();

	errs	+= ai64_query(args->fd, -1, 1, AI64_QUERY_LOW_LATENCY, &ll);
	errs	+= ai64_initialize(args->fd, -1, 1);
	errs	+= ai64_query(args->fd, -1, 0, AI64_QUERY_MASTER_CLOCK, &fref);
	nrate	= fref / 10000;

	gsc_label_level_dec();

	//===============================================================
	gsc_label("SYNC Output");
	printf("\n");

	gsc_label_level_inc();
	errs	+= ai64_ai_scan_size		(args->fd, -1, 1, AI64_AI_SCAN_SIZE_SINGLE,	NULL);
	errs	+= ai64_ext_sync_enable		(args->fd, -1, 1, AI64_EXT_SYNC_ENABLE_YES,	NULL);
	errs	+= ai64_ai_clk_src			(args->fd, -1, 1, AI64_AI_CLK_SRC_RAG,		NULL);
	errs	+= ai64_rag_nrate			(args->fd, -1, 1, nrate,						NULL);
	errs	+= ai64_rag_enable			(args->fd, -1, 1, AI64_GEN_ENABLE_YES,		NULL);
	errs	+= ai64_fsamp_ai_report_all	(args->fd, -1, 1, &sps);
	gsc_label_level_dec();

	//===============================================================
	sprintf(buf, "Waiting (%ld sec%s)", (long) args->seconds, (args->seconds == 1) ? "" : "s");
	gsc_label(buf);

	if (ll)
	{
		printf("SKIPPED  (Low Latency Board)\n");
	}
	else
	{
		os_sleep_ms(args->seconds * 1000);
		printf("Done\n");
	}

	return(errs);
}



