// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/samples/savedata/main.h $
// $Rev: 55151 $
// $Date: 2024-08-30 10:35:48 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "16ai64_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))

#define	FORMAT_HEX				0
#define	FORMAT_DEC				1
#define	FORMAT_DEC_0			2
#define	FORMAT_VOLT				3



// data types *****************************************************************

typedef struct
{
	// Application Settings

	int		argc;
	char**	argv;

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	format;			// Save data in this format.
	s32	force_save;		// Save data even if there are errors?
	s32	fsamp;			// Desired sample rate.
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	repeat;			// repeat data retrieval this many times
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for device to access.

	// Device Settings

	s32	ai_mode;		// Analog Input Mode
	s32	io_mode;
} args_t;



// prototypes *****************************************************************

int	perform_tests(const args_t* args);



#endif
