// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/samples/rxrate/perform.c $
// $Rev: 55152 $
// $Date: 2024-08-30 10:36:01 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_1M		(1024 * 1024)	// size of driver's transfer buffer



// variables ******************************************************************

static	u8	_data[_1M];



//*****************************************************************************
static int _configuration(const args_t* args, s32* ll)
{
	int	errs	= 0;

	errs	+= ai64_config_ai	(args->fd, -1, 1, AI64_AI_SCAN_SIZE_SINGLE, args->fsamp);
	errs	+= ai64_query		(args->fd, -1, 0, AI64_QUERY_LOW_LATENCY, ll);
	errs	+= ai64_rx_io_mode	(args->fd, -1, 1, args->io_mode, NULL);
	errs	+= ai64_ai_buf_clear(args->fd, -1, 1);

	return(errs);
}



//*****************************************************************************
static int _rate_test(const args_t* args, long get)
{
	struct timeval	begin;
	int				errs	= 0;
	long			got;
	long long		limit	= (long long) args->rx_mb * 1000000L;
	struct timeval	minimum;
	struct timeval	now;
	long long		sps;
	long long		total	= 0;
	long			us;

	gsc_label("Reading");

	gettimeofday(&begin, NULL);
	minimum.tv_sec	= begin.tv_sec + args->seconds;
	minimum.tv_usec	= begin.tv_usec;

	for (;;)
	{
		got	= ai64_read(args->fd, _data, get);

		if (got < 0)
		{
			errs++;
			printf("FAIL <--- (read");
			printf(", total so far %lld", total);
			printf(", requested %ld bytes", (long) get);
			printf(", error %ld)\n", got);
			break;
		}

		gettimeofday(&now, NULL);
		total	+= got;

		if (total < limit)
			continue;

		if (now.tv_sec < minimum.tv_sec)
			continue;

		if ((now.tv_sec == minimum.tv_sec) && (now.tv_usec < minimum.tv_usec))
			continue;

		us	= (now.tv_sec - begin.tv_sec) * 1000000L
			+ (now.tv_usec - begin.tv_usec);
		sps	= (total * 10000000L / 4 / us + 5) / 10;

		printf(	"PASS  (");
		gsc_label_long_comma(total / 4);
		printf(" Samples, %ld.%06ld Seconds, ", us / 1000000, us % 1000000);
		gsc_label_long_comma(sps);
		printf(" S/S)\n");
		break;
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int		errs	= 0;
	long	get		= sizeof(_data);
	s32		ll;

	errs	+= _configuration(args, &ll);

	if (ll)
	{
		printf("SKIPPED  (Low Latency Board)\n");
	}
	else
	{
		gsc_label ("Read Rate");
		printf("(%d second minimum, %ld MB minimum)\n", args->seconds, (long) args->rx_mb);
		gsc_label_level_inc();

		errs	+= _rate_test(args, get);

		gsc_label_level_dec();
	}

	return(errs);
}



