// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/samples/id/perform.c $
// $Rev: 55149 $
// $Date: 2024-08-30 10:34:09 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _input_modes(void)
{
	gsc_label("Input Modes");
	printf("Differential, Single Ended, Zero Test, +Vref Test\n");
}



//*****************************************************************************
static void _voltage_ranges(void)
{
	gsc_label("Voltage Ranges");
	printf("+-10V, +-5V, +-2.5V\n");
}



//*****************************************************************************
static void _clocking_sources(void)
{
	gsc_label("Clocking Sources");
	printf("Rate Generators, External, Software\n");
}



//*****************************************************************************
static void _sampling_modes(void)
{
	gsc_label("Sampling Modes");
	printf("Continuous, Single Shot\n");
}



//*****************************************************************************
static int _id_device_reg(const args_t* args)
{
	int						errs;
	gsc_reg_def_t			list[2]	= { { NULL }, { NULL } };
	const gsc_reg_def_t*	ptr;

	printf("\n");
	ptr	= ai64_reg_get_def_id(AI64_GSC_BCR);

	if (ptr)
	{
		list[0]	= ptr[0];
		errs	= gsc_reg_list(args->fd, list, 1, ai64_reg_read);
	}
	else
	{
		errs	= 1;
		printf(	"FAIL <---  (%d. ai64_reg_get_def_id, AI64_GSC_BCR)\n",
				__LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _register_map(const args_t* args)
{
	int	errs;

	printf("\n");
	errs	= ai64_reg_list(args->fd, args->detail);
	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;
	int	i;

	gsc_label("Device Features");
	printf("\n");

	gsc_label_level_inc();

	_input_modes();
	_voltage_ranges();
	_clocking_sources();
	_sampling_modes();

	for (i = 0; i < AI64_IOCTL_QUERY_LAST; i++)
		errs	+= ai64_query(args->fd, -1, 1, i, NULL);

	gsc_label_level_dec();

	errs	+= _id_device_reg(args);
	errs	+= _register_map(args);
	printf("\n");

	return(errs);
}


