// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/samples/fsamp/perform.c $
// $Rev: 55148 $
// $Date: 2024-08-30 10:33:56 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	FILE_NAME				"fsamp.txt"
#define	LIMIT_MAX(v,max)		(((v) > (max)) ? (max) : (v))
#define	LIMIT_MIN(v,min)		(((v) < (min)) ? (min) : (v))
#define	LIMIT_RANGE(v,min,max)	(LIMIT_MIN((LIMIT_MAX((v),(max))),(min)))



//*****************************************************************************
static int _hold_secs(const args_t* args, s32 fsamp)
{
	char	buf[80];
	int		errs	= 0;

	gsc_label("Config");
	errs	+= ai64_config_ai	(args->fd, -1, 0, AI64_AI_SCAN_SIZE_SINGLE, fsamp);
	printf("%s\n", errs ? "FAIL <---" : "PASS");

	if (args->hold_reg_dump)
		ai64_reg_list(args->fd, 1);

	strcpy(buf, "Holding ");
	gsc_label_long_comma_buf(args->hold_secs, buf + strlen(buf));
	strcat(buf, " secs");
	gsc_label(buf);

	if (errs == 0)
	{
		os_sleep_ms(args->hold_secs * 1000);
		printf("Done\n");
	}
	else
	{
		printf("Aborting due to error.\n");
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	s32			enable_a;
	s32			enable_b;
	int			errs	= 0;
	FILE*		file	= NULL;
	s32			fsamp;
	s32			max		= args->fsamp;
	s32			min		= args->fsamp;
	const char*	name	= FILE_NAME;
	s32			nrate_a;
	s32			nrate_b;
	double		rate;
	s32			src;
	s32			src_b;

	gsc_label("Fsamp Computation");
	printf("\n");
	gsc_label_level_inc();

	errs	+= ai64_query(args->fd, -1, 0, AI64_QUERY_FSAMP_MAX, &max);
	errs	+= ai64_query(args->fd, -1, 0, AI64_QUERY_FSAMP_MIN, &min);

	if (args->range == 0)
	{
		min	= LIMIT_RANGE(args->fsamp, min, max);
		max	= min;
	}
	else
	{
		min	= LIMIT_RANGE(args->range_begin, min, max);
		max	= LIMIT_RANGE(args->range_end, min, max);
	}

	if (args->save)
	{
		file	= fopen(name, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", name);
			errs	= 1;
		}
		else
		{
			fprintf(file, "# 16AI64 Scan Rates\n");
			fprintf(file, "# Request   Produced\n");
			fprintf(file, "# ========  ==========\n");
		}
	}

	for (fsamp = min; fsamp <= max; fsamp++)
	{
		errs	+= ai64_fsamp_ai_compute(args->fd, -1, 1, fsamp, &src, &src_b, &nrate_a, &nrate_b, &enable_a, &enable_b, &rate);

		if (args->hold_secs)
			errs	+= _hold_secs(args, fsamp);

		if (file)
			fprintf(file, "%10ld  %10.3f\n", (long) fsamp, (float) rate);
	}

	if (file)
		fclose(file);

	gsc_label_level_dec();
	return(errs);
}


