// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/samples/bcr_sync/perform.c $
// $Rev: 55147 $
// $Date: 2024-08-30 10:33:42 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#ifdef CLOCK_MONOTONIC_RAW
#define	CLOCK		CLOCK_MONOTONIC_RAW
#else
#ifdef CLOCK_MONOTONIC
#define	CLOCK		CLOCK_MONOTONIC
#else
#define	CLOCK		CLOCK_REALTIME
#endif
#endif



//*****************************************************************************
#ifndef	CLOCK_MONOTONIC_RAW
#define	clock_gettime(c,ts)	_my_clock_gettime(ts)

static int _my_clock_gettime(struct timespec* ts)
{
	int				ret;
	struct timeval	tv;

	if (ts)
	{
		ret	= 0;
		gettimeofday(&tv, NULL);
		ts->tv_sec	= tv.tv_sec;
		ts->tv_nsec	= tv.tv_usec * 1000;
	}
	else
	{
		ret	= 1;
	}

	return(ret);
}
#endif



//*****************************************************************************
static int _channels(const args_t* args, s32* chans)
{
	s32		active;
	char	buf[64];
	int		errs	= 0;
	int		ret;
	s32		single	= -1;

	gsc_label("Input Channels");

	active	= -1;
	ret		= ai64_ioctl(args->fd, AI64_IOCTL_AI_SCAN_SIZE,	&active	);
	errs	+= ret ? 1 : 0;
	ret		= ai64_ioctl(args->fd, AI64_IOCTL_CHAN_SINGLE,	&single	);
	errs	+= ret ? 1 : 0;

	if (errs == 0)
	{
		switch (active)
		{
			default:

				errs++;
				printf("FAIL <---  (invalid ACTIVE selection: %ld)\n", (long) active);
				break;

			case AI64_AI_SCAN_SIZE_SINGLE:

				chans[0]	= 1;
				sprintf(buf, "# %ld", (long) single);
				break;

			case AI64_AI_SCAN_SIZE_0_1:

				chans[0]	= 2;
				strcpy(buf, "#s 0-1");
				break;

			case AI64_AI_SCAN_SIZE_0_3:

				chans[0]	= 4;
				strcpy(buf, "#s 0-3");
				break;

			case AI64_AI_SCAN_SIZE_0_7:

				chans[0]	= 8;
				strcpy(buf, "#s 0-7");
				break;

			case AI64_AI_SCAN_SIZE_0_15:

				chans[0]	= 16;
				strcpy(buf, "#s 0-15");
				break;

			case AI64_AI_SCAN_SIZE_0_31:

				chans[0]	= 32;
				strcpy(buf, "#s 0-31");
				break;

			case AI64_AI_SCAN_SIZE_0_63:

				chans[0]	= 64;
				strcpy(buf, "#s 0-63");
				break;
		}

		if (errs == 0)
		{
			printf(	"%ld Channel%s  (%s)\n",
					(long) chans[0],
					(chans[0] == 1) ? "" : "s",
					buf);
		}
	}

	return(errs);
}



//*****************************************************************************
static int _read_data(const args_t* args)
{
	int				errs		= 0;
	s32				get;
	int				get_last	= -1;
	int				i;
	struct timespec	now;
	long long		ns;
	struct timespec	start;

	errs	+= ai64_ai_sync(args->fd, -1, 1);
	clock_gettime(CLOCK, &start);

	for (i = 0; i < 10000; i++)
	{
		errs	+= ai64_ai_buf_level(args->fd, -1, 0, &get);

		if ((i == 0) || (get != get_last))
		{
			clock_gettime(CLOCK, &now);
			ns	= ((long long) now.tv_sec * 1000000000 + now.tv_nsec)
				- ((long long) start.tv_sec * 1000000000 + start.tv_nsec);
			printf("%11lld ns  %d sample%s\n", ns, get, (get == 1) ? "" : "s");
		}

		get_last	= get;
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	char	buf[64];
	s32		chans	= 32;
	s32		enable_a;
	s32		enable_b;
	int		err;
	int		errs	= 0;
	int		fsamp;
	int		i;
	s32		ll;
	s32		nrate_a;
	s32		nrate_b;
	s32		src;
	s32		src_b;

	errs	+= ai64_query(args->fd, -1, 1, AI64_QUERY_LOW_LATENCY, &ll);

	if (ll)
	{
		printf("SKIPPED  (Low Latency Board)\n");
	}
	else
	{
		for (i = 0; i < 2; i++)
		{
			fsamp	= i ? 300000 : (350000 / 32);
			gsc_label_long_comma_buf(fsamp, buf);
			strcat(buf, " S/S RBG Test");
			gsc_label(buf);
			printf("\n");
			gsc_label_level_inc();

			errs	+= _channels(args, &chans);

			gsc_label("Configuration");
			err		= ai64_config_ai(args->fd, -1, 0, AI64_AI_SCAN_SIZE_0_31, fsamp);
			printf("%s\n", err ? "FAIL <---" : "PASS");
			errs	+= err;

			errs	+= ai64_fsamp_ai_compute(args->fd, -1, 1, fsamp, &src, &src_b, &nrate_a, &nrate_b, &enable_a, &enable_b, NULL);
			errs	+= ai64_ai_clk_src		(args->fd, -1, 1, src, NULL);
			errs	+= ai64_rag_nrate		(args->fd, -1, 1, nrate_a, NULL);
			errs	+= ai64_rag_enable		(args->fd, -1, 1, enable_a, NULL);
			errs	+= ai64_rbg_clk_src		(args->fd, -1, 1, src_b, NULL);
			errs	+= ai64_rbg_nrate		(args->fd, -1, 1, nrate_b, NULL);
			errs	+= ai64_rag_enable		(args->fd, -1, 1, enable_b, NULL);

			errs	+= ai64_ai_mode			(args->fd, -1, 1, args->ai_mode, NULL);
			errs	+= ai64_ai_clk_src		(args->fd, -1, 1, AI64_AI_CLK_SRC_BCR, NULL);
			errs	+= ai64_ai_buf_clear	(args->fd, -1, 1);
			errs	+= _read_data(args);

			gsc_label_level_dec();
		}
	}

	return(errs);
}



