// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/include/16ai64_utils.h $
// $Rev: 55144 $
// $Date: 2024-08-30 10:31:37 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Utilities: header file

#ifndef	__16AI64_UTILS_H__
#define	__16AI64_UTILS_H__

#include "16ai64_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	ai64_close_util			(int fd, int index, int verbose);
int ai64_init_util			(int verbose);
int ai64_ioctl_util			(int fd, int index, int verbose, int request, void* arg);
int	ai64_open_util			(int device, int share, int index, int verbose, int* fd);
int	ai64_read_util			(int fd, int index, int verbose, void* dst, size_t bytes, size_t* got);

// IOCTL utility services

int	ai64_ai_buf_clear		(int fd, int index, int verbose);								// AI64_IOCTL_AI_BUF_CLEAR
int	ai64_ai_buf_level		(int fd, int index, int verbose,		  s32* get);			// AI64_IOCTL_AI_BUF_LEVEL
int	ai64_ai_buf_thr_lvl		(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_AI_BUF_THR_LVL
int	ai64_ai_buf_thr_sts		(int fd, int index, int verbose,		  s32* get);			// AI64_IOCTL_AI_BUF_THR_STS
int	ai64_ai_clk_src			(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_AI_CLK_SRC
int	ai64_ai_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_AI_MODE
int	ai64_ai_range			(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_AI_RANGE
int	ai64_ai_scan_size		(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_AI_SCAN_SIZE
int	ai64_ai_sync			(int fd, int index, int verbose);								// AI64_IOCTL_AI_SYNC
int	ai64_autocal			(int fd, int index, int verbose);								// AI64_IOCTL_AUTOCAL
int	ai64_autocal_status		(int fd, int index, int verbose, s32* get);						// AI64_IOCTL_AUTOCAL_STATUS
int	ai64_chan_single		(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_CHAN_SINGLE
int ai64_conv_counter		(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_CONV_COUNT
int	ai64_data_format		(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_DATA_FORMAT
int	ai64_ext_sync_enable	(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_EXT_SYNC_ENABLE
int	ai64_initialize			(int fd, int index, int verbose);								// AI64_IOCTL_INITIALIZE
int	ai64_irq0_sel			(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_IRQ0_SEL
int	ai64_irq1_sel			(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_IRQ1_SEL
int ai64_low_lat_read		(int fd, int index, int verbose, ai64_ll_t* get);				// AI64_IOCTL_LOW_LAT_READ
int	ai64_query				(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_QUERY
int	ai64_rag_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_RAG_ENABLE
int	ai64_rag_nrate			(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_RAG_NRATE
int	ai64_rbg_clk_src		(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_RBG_CLK_SRC
int	ai64_rbg_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_RBG_ENABLE
int	ai64_rbg_nrate			(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_RBG_NRATE
int	ai64_reg_mod			(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// AI64_IOCTL_REG_MOD
int	ai64_reg_read			(int fd, int index, int verbose, u32 reg, u32* value);			// AI64_IOCTL_REG_READ
int	ai64_reg_write			(int fd, int index, int verbose, u32 reg, u32 value);			// AI64_IOCTL_REG_WRITE
int ai64_reset_inputs		(int fd, int index, int verbose);								// AI64_IOCTL_RESET_INPUTS
int	ai64_rx_io_abort		(int fd, int index, int verbose,		  s32* get);			// AI64_IOCTL_RX_IO_ABORT
int	ai64_rx_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_RX_IO_MODE
int	ai64_rx_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_RX_IO_TIMEOUT
int ai64_scan_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AI64_IOCTL_SCAN_ENABLE
int	ai64_wait_cancel		(int fd, int index, int verbose, gsc_wait_t* wait);				// AI64_IOCTL_WAIT_CANCEL
int	ai64_wait_event			(int fd, int index, int verbose, gsc_wait_t* wait);				// AI64_IOCTL_WAIT_EVENT
int	ai64_wait_status		(int fd, int index, int verbose, gsc_wait_t* wait);				// AI64_IOCTL_WAIT_STATUS

// Auxiliary utility services

int	ai64_config_ai			(int fd, int index, int verbose, s32 scan_size, s32 fsamp);
int	ai64_fsamp_ai_compute	(int fd, int index, int verbose, s32 fsamp, s32* src, s32* src_b, s32* nrate_a, s32* nrate_b, s32* enable_a, s32* enable_b, double* rate);
int	ai64_fsamp_ai_report	(int fd, int index, int verbose, int chan, s32* fsamp);
int ai64_fsamp_ai_report_all(int fd, int index, int verbose, s32* fsamp);
int	ai64_id_device			(int fd, int index, int verbose);

int	ai64_count_boards		(int verbose, s32* get);
int	ai64_reg_list			(int fd, int detail);

const gsc_reg_def_t*		ai64_reg_get_def_id(u32 reg);
const gsc_reg_def_t*		ai64_reg_get_def_index(int index);
const char*					ai64_reg_get_desc(u32 reg);
const char*					ai64_reg_get_name(u32 reg);



#endif
