// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI64/16AI64_Linux_3.x.x.x_DN/driver/16ai64.h $
// $Rev: 55155 $
// $Date: 2024-08-30 10:38:53 -0500 (Fri, 30 Aug 2024) $

// 16AI64: Device Driver: header file

#ifndef	__16AI64_H__
#define	__16AI64_H__

#include "gsc_common.h"
#include "gsc_pci9080.h"



// macros *********************************************************************

#define	AI64_BASE_NAME						"16ai64"

// IOCTL command codes
#define	AI64_IOCTL_REG_READ					OS_IOCTL_RW( 0,  12, gsc_reg_t)
#define	AI64_IOCTL_REG_WRITE				OS_IOCTL_W ( 1,  12, gsc_reg_t)
#define	AI64_IOCTL_REG_MOD					OS_IOCTL_W ( 2,  12, gsc_reg_t)
#define	AI64_IOCTL_QUERY					OS_IOCTL_RW( 3,   4, s32)
#define	AI64_IOCTL_INITIALIZE				OS_IOCTL   ( 4)
#define	AI64_IOCTL_AUTOCAL					OS_IOCTL   ( 5)
#define	AI64_IOCTL_AUTOCAL_STATUS			OS_IOCTL_R ( 6,   4, s32)
#define	AI64_IOCTL_AI_BUF_CLEAR				OS_IOCTL   ( 7)
#define	AI64_IOCTL_AI_BUF_LEVEL				OS_IOCTL_R ( 8,   4, s32)
#define	AI64_IOCTL_AI_BUF_THR_LVL			OS_IOCTL_RW( 9,   4, s32)
#define	AI64_IOCTL_AI_BUF_THR_STS			OS_IOCTL_R (10,   4, s32)
#define	AI64_IOCTL_AI_CLK_SRC				OS_IOCTL_RW(11,   4, s32)
#define	AI64_IOCTL_AI_MODE					OS_IOCTL_RW(12,   4, s32)
#define	AI64_IOCTL_AI_RANGE					OS_IOCTL_RW(13,   4, s32)
#define	AI64_IOCTL_AI_SCAN_SIZE				OS_IOCTL_RW(14,   4, s32)
#define	AI64_IOCTL_AI_SYNC					OS_IOCTL   (15)
#define	AI64_IOCTL_CHAN_SINGLE				OS_IOCTL_RW(16,   4, s32)
#define	AI64_IOCTL_DATA_FORMAT				OS_IOCTL_RW(17,   4, s32)
#define	AI64_IOCTL_EXT_SYNC_ENABLE			OS_IOCTL_RW(18,   4, s32)
#define	AI64_IOCTL_IRQ0_SEL					OS_IOCTL_RW(19,   4, s32)
#define	AI64_IOCTL_IRQ1_SEL					OS_IOCTL_RW(20,   4, s32)
#define	AI64_IOCTL_RAG_ENABLE				OS_IOCTL_RW(21,   4, s32)
#define	AI64_IOCTL_RAG_NRATE				OS_IOCTL_RW(22,   4, s32)
#define	AI64_IOCTL_RBG_CLK_SRC				OS_IOCTL_RW(23,   4, s32)
#define	AI64_IOCTL_RBG_ENABLE				OS_IOCTL_RW(24,   4, s32)
#define	AI64_IOCTL_RBG_NRATE				OS_IOCTL_RW(25,   4, s32)
#define	AI64_IOCTL_RX_IO_ABORT				OS_IOCTL_R (26,   4, s32)
#define	AI64_IOCTL_RX_IO_MODE				OS_IOCTL_RW(27,   4, s32)
#define	AI64_IOCTL_RX_IO_TIMEOUT			OS_IOCTL_RW(28,   4, s32)
#define	AI64_IOCTL_WAIT_CANCEL				OS_IOCTL_RW(29,  28, gsc_wait_t)
#define	AI64_IOCTL_WAIT_EVENT				OS_IOCTL_RW(30,  28, gsc_wait_t)
#define	AI64_IOCTL_WAIT_STATUS				OS_IOCTL_RW(31,  28, gsc_wait_t)
#define	AI64_IOCTL_CONV_COUNT				OS_IOCTL_RW(32,   4, s32)
#define	AI64_IOCTL_SCAN_ENABLE				OS_IOCTL_RW(33,   4, s32)
#define	AI64_IOCTL_LOW_LAT_READ				OS_IOCTL_R (34, 132, ai64_ll_t)
#define	AI64_IOCTL_RESET_INPUTS				OS_IOCTL   (35)

// Retained for backwards compatibility.
#define	AI64_IOCTL_AUTO_CALIBRATE			AI64_IOCTL_AUTOCAL
#define	AI64_IOCTL_AUTO_CAL_STS				AI64_IOCTL_AUTOCAL_STATUS

//*****************************************************************************
// AI64_IOCTL_REG_READ
// AI64_IOCTL_REG_WRITE
// AI64_IOCTL_REG_MOD
//
#define	AI64_REG_ENCODE(s,o)				GSC_REG_ENCODE(GSC_REG_TYPE_BAR2,(s),(o))
// Parameter:	gsc_reg_t*
#define	AI64_GSC_BCR						AI64_REG_ENCODE(4,0x00)// Board Control Register
#define	AI64_GSC_ICR						AI64_REG_ENCODE(4,0x04)// Interrupt Control Register
#define	AI64_GSC_IDBR						AI64_REG_ENCODE(4,0x08)// Input Data Buffer Register
#define	AI64_GSC_IBCR						AI64_REG_ENCODE(4,0x0C)// Input Buffer Control Register
#define	AI64_GSC_RAGR						AI64_REG_ENCODE(4,0x10)// Rate-A Generator Register
#define	AI64_GSC_RBGR						AI64_REG_ENCODE(4,0x14)// Rate-B Generator Register
#define	AI64_GSC_BSR						AI64_REG_ENCODE(4,0x18)// Buffer Size Register
#define	AI64_GSC_CCR						AI64_REG_ENCODE(4,0x18)// Conversion Counter Register
#define	AI64_GSC_SSCR						AI64_REG_ENCODE(4,0x20)// Scan & Sync Control Register
#define	AI64_GSC_FRR						AI64_REG_ENCODE(4,0x28)// Firmware Revision Register

//*****************************************************************************
// AI64_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		The value returned is the answer to the query.

typedef enum
{
	AI64_QUERY_AUTOCAL_MS,		// Max autocalibrate period in ms.
	AI64_QUERY_CHANNEL_MAX,		// Maximum number of channels supported.
	AI64_QUERY_CHANNEL_QTY,		// The number of A/D channels.
	AI64_QUERY_COUNT,			// The number of query options.
	AI64_QUERY_DEVICE_TYPE,		// Value from gsc_dev_type_t
	AI64_QUERY_FIFO_SIZE,		// FIFO depth in 32-bit samples
	AI64_QUERY_FSAMP_MAX,		// The maximum sample rate per channel.
	AI64_QUERY_FSAMP_MIN,		// The minimum sample rate per channel.
	AI64_QUERY_INIT_MS,			// Max initialize period in ms.
	AI64_QUERY_MASTER_CLOCK,	// Master clock frequency
	AI64_QUERY_NRATE_MAX,		// Maximum rate generator Nrate value.
	AI64_QUERY_NRATE_MIN,		// Maximum rate generator Nrate value.
	AI64_QUERY_RATE_GEN_QTY,	// Number of Rate Generatorts.
	AI64_QUERY_LOW_LATENCY,		// Is this a Low Latency Board?
	AI64_QUERY_REG_BSR,			// Buffer Size Register
	AI64_QUERY_REG_CCR,			// Conversion Counter Register
	AI64_QUERY_REG_IBCR,		// Input Buffer Control Register
	AI64_QUERY_REG_IDBR,		// Input Data Buffer Register
	AI64_QUERY_REG_RAGR,		// Rate-A Generator Register
	AI64_QUERY_REG_RBGR,		// Rate-B Generator Register
	AI64_QUERY_IRQ1,			// is the IRQ-1 feature supported?

	AI64_IOCTL_QUERY_LAST		// MUST BE LAST!
} ai64_query_t;

#define	AI64_IOCTL_QUERY_ERROR				(-1)

// Retained for backwards compatibility.
#define	AI64_QUERY_AUTO_CAL_MS	AI64_QUERY_AUTOCAL_MS

//*****************************************************************************
// AI64_IOCTL_INITIALIZE					BCR D15
//
//	Parameter:	None

//*****************************************************************************
// AI64_IOCTL_AUTOCAL						BCR D13
//
//	Parameter:	None

//*****************************************************************************
// AI64_IOCTL_AUTOCAL_STATUS				BCR D13, D14
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AI64_AUTOCAL_STATUS_ACTIVE			0
#define	AI64_AUTOCAL_STATUS_FAIL			1
#define	AI64_AUTOCAL_STATUS_PASS			2

// Retained for backwards compatibility.
#define	AI64_AUTO_CAL_STS_ACTIVE			AI64_AUTOCAL_STATUS_ACTIVE
#define	AI64_AUTO_CAL_STS_FAIL				AI64_AUTOCAL_STATUS_FAIL
#define	AI64_AUTO_CAL_STS_PASS				AI64_AUTOCAL_STATUS_PASS

//*****************************************************************************
// AI64_IOCTL_AI_BUF_CLEAR					IBCR D16
//
//	Parameter:	None.

//*****************************************************************************
// AI64_IOCTL_AI_BUF_LEVEL					BSR D0-D15
//
//	Parameter:	s32*
//		The value returned is the current input buffer fill level.

//*****************************************************************************
// AI64_IOCTL_AI_BUF_THR_LVL				IBCR D0-D15
//
//	Parameter:	s32*
//		Pass in any valid value from 0x0 to 0xFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AI64_IOCTL_AI_BUF_THR_STS				IBCR D17
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AI64_AI_BUF_THR_STS_CLEAR			0
#define	AI64_AI_BUF_THR_STS_SET				1

//*****************************************************************************
// AI64_IOCTL_AI_CLK_SRC					SSCR D3-D4
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI64_AI_CLK_SRC_RAG					0
#define	AI64_AI_CLK_SRC_RBG					1
#define	AI64_AI_CLK_SRC_EXT					2
#define	AI64_AI_CLK_SRC_BCR					3

//*****************************************************************************
// AI64_IOCTL_AI_MODE						BCR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI64_AI_MODE_DIFF					0
#define	AI64_AI_MODE_SINGLE					1
#define	AI64_AI_MODE_ZERO					2
#define	AI64_AI_MODE_VREF					3

//*****************************************************************************
// AI64_IOCTL_AI_RANGE						BCR D4-D5
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI64_AI_RANGE_2_5V					0	// +- 2.5 volts
#define	AI64_AI_RANGE_5V					1	// +- 5 volts
#define	AI64_AI_RANGE_10V					2	// +- 10 volts

//*****************************************************************************
// AI64_IOCTL_AI_SCAN_SIZE					SSCR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI64_AI_SCAN_SIZE_SINGLE			0	// software specifies channel
#define	AI64_AI_SCAN_SIZE_0_1				1
#define	AI64_AI_SCAN_SIZE_0_3				2
#define	AI64_AI_SCAN_SIZE_0_7				3
#define	AI64_AI_SCAN_SIZE_0_15				4
#define	AI64_AI_SCAN_SIZE_0_31				5
#define	AI64_AI_SCAN_SIZE_0_63				6	// Single Ended ONLY!

//*****************************************************************************
// AI64_IOCTL_AI_SYNC						BCR D12
//
//	Parameter:	None.

//*****************************************************************************
// AI64_IOCTL_CHAN_SINGLE					SSCR D12-D17
//
//	Parameter:	s32*
//		Pass in any valid value from zero to 31 (differential) or 63 (single ended), or
//		-1 to read the current setting.

//*****************************************************************************
// AI64_IOCTL_DATA_FORMAT					BCR D6
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI64_DATA_FORMAT_2S_COMP			0	// Twos Compliment
#define	AI64_DATA_FORMAT_OFF_BIN			1	// Offset Binary

//*****************************************************************************
// AI64_IOCTL_EXT_SYNC_ENABLE				BCR D7
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AI64_EXT_SYNC_ENABLE_NO				0
#define	AI64_EXT_SYNC_ENABLE_YES			1

//*****************************************************************************
// AI64_IOCTL_IRQ0_SEL						ICR D0-D2
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI64_IRQ0_INIT_DONE					0
#define	AI64_IRQ0_AUTOCAL_DONE				1
#define	AI64_IRQ0_SYNC_START				2
#define	AI64_IRQ0_SYNC_DONE					3

// Retained for backwards compatibility.
#define	AI64_IRQ0_AUTO_CAL_DONE				AI64_IRQ0_AUTOCAL_DONE

//*****************************************************************************
// AI64_IOCTL_IRQ1_SEL						ICR D4-D6
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI64_IRQ1_NONE						0
#define	AI64_IRQ1_IN_BUF_THR_L2H			1
#define	AI64_IRQ1_IN_BUF_THR_H2L			2

//*****************************************************************************
// AI64_IOCTL_RAG_ENABLE					RAGR D16
// AI64_IOCTL_RBG_ENABLE					RBGR D16
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI64_GEN_ENABLE_NO					1
#define	AI64_GEN_ENABLE_YES					0

//*****************************************************************************
// AI64_IOCTL_RAG_NRATE						RAGR D0-D15
// AI64_IOCTL_RBG_NRATE						RBGR D0-D15
//
//	Parameter:	s32*
//		Pass in any value between 48 to 0xFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AI64_IOCTL_RBG_CLK_SRC					SSCR D10
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI64_RBG_CLK_SRC_MASTER				0
#define	AI64_RBG_CLK_SRC_RAG				1

//*****************************************************************************
// AI64_IOCTL_RX_IO_ABORT					This is a software feature.
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AI64_IO_ABORT_NO					0
#define	AI64_IO_ABORT_YES					1

//*****************************************************************************
// AI64_IOCTL_RX_IO_MODE					This is a software setting.
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
#define	AI64_IO_MODE_DEFAULT				GSC_IO_MODE_PIO
// GSC_IO_MODE_PIO
// GSC_IO_MODE_BMDMA

//*****************************************************************************
// AI64_IOCTL_RX_IO_TIMEOUT (in seconds)	This is a software setting.
//
//	Parameter:	s32*
//		Pass in any value from the minimim to the maximim, the infinite option,
//		or -1 to read the current setting. The value -1 is returned if the
//		feature is not supported, but this should never happen.
#define	AI64_IO_TIMEOUT_DEFAULT				10
#define	AI64_IO_TIMEOUT_NO_SLEEP			0
#define	AI64_IO_TIMEOUT_MIN					0
#define	AI64_IO_TIMEOUT_MAX					GSC_IO_TIMEOUT_MAX
#define	AI64_IO_TIMEOUT_INFINITE			GSC_IO_TIMEOUT_INFINITE

//*****************************************************************************
// AI64_IOCTL_WAIT_CANCEL					fields need not be valid
// AI64_IOCTL_WAIT_EVENT					all fields must be valid
// AI64_IOCTL_WAIT_STATUS					fields need not be valid
//
//	Parameter:	gsc_wait_t*
// gsc_wait_t.flags - see gsc_common.h
// gsc_wait_t.main - see gsc_common.h
// gsc_wait_t.gsc
#define	AI64_WAIT_GSC_INIT_DONE				0x0001
#define	AI64_WAIT_GSC_AUTOCAL_DONE			0x0002
#define	AI64_WAIT_GSC_SYNC_START			0x0004
#define	AI64_WAIT_GSC_SYNC_DONE				0x0008
#define	AI64_WAIT_GSC_IN_BUF_THR_L2H		0x0010
#define	AI64_WAIT_GSC_IN_BUF_THR_H2L		0x0020
#define	AI64_WAIT_GSC_ALL					0x003F
// gsc_wait_t.alt flags
#define	AI64_WAIT_ALT_ALL					0x0000
// gsc_wait_t.io
#define	AI64_WAIT_IO_RX_ABORT				0x0001
#define	AI64_WAIT_IO_RX_DONE				0x0002
#define	AI64_WAIT_IO_RX_ERROR				0x0004
#define	AI64_WAIT_IO_RX_TIMEOUT				0x0008

#define	AI64_WAIT_IO_ALL					0x000F

// Retained for backwards compatibility.
#define	AI64_WAIT_GSC_AUTO_CAL_DONE			AI64_WAIT_GSC_AUTOCAL_DONE

//*****************************************************************************
// AI64_IOCTL_CONV_COUNT					CCR D0-D19		Low Latency only
//
//	Parameter:	s32*
//		Pass in any value between 0 to 0xFFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AI64_IOCTL_SCAN_ENABLE					SSCR D5		Low Latency only
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AI64_SCAN_ENABLE_NO					0
#define	AI64_SCAN_ENABLE_YES				1

//*****************************************************************************
// AI64_IOCTL_LOW_LAT_READ					LLHR00-LLHR63
//
//	Parameter:	ai64_ll_t*

typedef struct
{
	s16	ret;
	u16	reserved;
	u16	data[64];
} ai64_ll_t;

//*****************************************************************************
// AI64_IOCTL_RESET_INPUTS					SSCR D18	Low Latency only
//
//	Parameter:	None.



#endif
