// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_tt_thr_xx.c $
// $Rev: 53690 $
// $Date: 2023-09-07 13:47:54 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_tt_thr_xx
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_TT_THR_XX service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		chan	The channel whose setting we're accessing.
*
*		set		The setting to apply.
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai32ssc_tt_thr_xx(int fd, int index, int verbose, int chan, s32 set, s32* get)
{
	static const long	cmd[]	=
	{
		AI32SSC_IOCTL_TT_THR_00,
		AI32SSC_IOCTL_TT_THR_01,
		AI32SSC_IOCTL_TT_THR_02,
		AI32SSC_IOCTL_TT_THR_03,
		AI32SSC_IOCTL_TT_THR_04,
		AI32SSC_IOCTL_TT_THR_05,
		AI32SSC_IOCTL_TT_THR_06,
		AI32SSC_IOCTL_TT_THR_07,
		AI32SSC_IOCTL_TT_THR_08,
		AI32SSC_IOCTL_TT_THR_09,
		AI32SSC_IOCTL_TT_THR_10,
		AI32SSC_IOCTL_TT_THR_11,
		AI32SSC_IOCTL_TT_THR_12,
		AI32SSC_IOCTL_TT_THR_13,
		AI32SSC_IOCTL_TT_THR_14,
		AI32SSC_IOCTL_TT_THR_15,
		AI32SSC_IOCTL_TT_THR_16,
		AI32SSC_IOCTL_TT_THR_17,
		AI32SSC_IOCTL_TT_THR_18,
		AI32SSC_IOCTL_TT_THR_19,
		AI32SSC_IOCTL_TT_THR_20,
		AI32SSC_IOCTL_TT_THR_21,
		AI32SSC_IOCTL_TT_THR_22,
		AI32SSC_IOCTL_TT_THR_23,
		AI32SSC_IOCTL_TT_THR_24,
		AI32SSC_IOCTL_TT_THR_25,
		AI32SSC_IOCTL_TT_THR_26,
		AI32SSC_IOCTL_TT_THR_27,
		AI32SSC_IOCTL_TT_THR_28,
		AI32SSC_IOCTL_TT_THR_29,
		AI32SSC_IOCTL_TT_THR_30,
		AI32SSC_IOCTL_TT_THR_31
	};

	char	buf[64];
	int		errs;
	int		ret;

	if (verbose)
	{
		sprintf(buf, "TT Threshold %02d", chan);
		gsc_label_index(buf, index);
	}

	if ((chan >= 0) && (chan <= 31))
	{
		ret		= ai32ssc_ioctl(fd, cmd[chan], &set);
		errs	= ret ? 1 : 0;

		if (verbose)
		{
			printf("%s  (", errs ? "FAIL <---" : "PASS");
			gsc_label_long_comma(set);
			printf(" items)\n");
		}

		if (get)
			get[0]	= set;
	}
	else
	{
		errs	= 1;

		if (verbose)
			printf("ERROR <--- (invalid channel %d)\n", chan);
	}

	return(errs);
}


