// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_tt_chan_mask.c $
// $Rev: 53690 $
// $Date: 2023-09-07 13:47:54 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_tt_chan_mask
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_TT_CHAN_MASK service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		The setting to apply.
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	ai32ssc_tt_chan_mask(int fd, int index, int verbose, u32 set, u32* get)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("TT Channel Mask", index);

	ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_TT_CHAN_MASK, &set);
	errs	= ret ? 1 : 0;

	if (errs)
		errs	= ai32ssc_reg_read(fd, -1, 0, AI32SSC_GSC_TTACMR, &set);

	if (verbose)
		printf("%s  (0x%08lX)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


