// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_scan_marker_val.c $
// $Rev: 53690 $
// $Date: 2023-09-07 13:47:54 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_scan_marker_val
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_SCAN_MARKER_VAL service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		The setting to apply.
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	ai32ssc_scan_marker_val(int fd, int index, int verbose, u32 set, u32* get)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Scan Marker Value", index);

	ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_SCAN_MARKER_VAL, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s  (0x%08lX)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


