// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_rx_io_timeout.c $
// $Rev: 53690 $
// $Date: 2023-09-07 13:47:54 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_rx_io_timeout
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_RX_IO_TIMEOUT service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		The setting to apply.
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	ai32ssc_rx_io_timeout(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("Rx I/O Timeout", index);

	ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_RX_IO_TIMEOUT, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
	{
		if (set == -1)
		{
			ptr	= "This service is not supported by this device.";
		}
		else if (set == AI32SSC_IO_TIMEOUT_INFINITE)
		{
			ptr	= "infinite/never timeout";
		}
		else
		{
			sprintf(buf, "%ld second%s", (long) set, (set == 1) ? "" : "s");
			ptr	= buf;
		}

		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);
	}

	if (get)
		get[0]	= set;

	return(errs);
}


