// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_rbg_nrate.c $
// $Rev: 53690 $
// $Date: 2023-09-07 13:47:54 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_rbg_nrate
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_RBG_NRATE service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		The setting to apply.
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int ai32ssc_rbg_nrate(int fd, int index, int verbose, s32 set, s32* get)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Rate-B Generator Nrate", index);

	ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_RBG_NRATE, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
	{
		printf("%s  (", errs ? "FAIL <---" : "PASS");
		gsc_label_long_comma(set);
		printf(")\n");
	}

	if (get)
		get[0]	= set;

	return(errs);
}


