// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_ll_read.c $
// $Rev: 51359 $
// $Date: 2022-07-12 16:39:44 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_ll_read
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_LL_READ service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai32ssc_ll_read(int fd, int index, int verbose, ai32ssc_ll_data_t* get)
{
	int					errs;
	s32					ret;
	ai32ssc_ll_data_t	set;

	if (verbose)
		gsc_label_index("LL Read", index);

	ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_LL_READ, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	if (get)
		get[0]	= set;

	return(errs);
}


