// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_ll_doh.c $
// $Rev: 51359 $
// $Date: 2022-07-12 16:39:44 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_ll_doh
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_LL_DOH service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai32ssc_ll_doh(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	s32			ret;

	if (verbose)
		gsc_label_index("LL Data On Hold", index);

	ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_LL_DOH, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs	= 1;
			ptr		= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case AI32SSC_LL_DOH_NO:

			ptr	= "No";
			break;

		case AI32SSC_LL_DOH_YES:

			ptr	= "Yes";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


