// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_initialize.c $
// $Rev: 54761 $
// $Date: 2024-07-01 17:03:44 -0500 (Mon, 01 Jul 2024) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_initialize
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_INITIALIZE service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	ai32ssc_initialize(int fd, int index, int verbose)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Initialize", index);

	ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_INITIALIZE, NULL);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}


