// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_config_aux.c $
// $Rev: 53690 $
// $Date: 2023-09-07 13:47:54 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_config_aux
*
*	Purpose:
*
*		Configure the Auxiliary services.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	ai32ssc_config_aux(int fd, int index, int verbose)
{
	int	errs	= 0;

	if (verbose)
	{
		gsc_label_index("Auxiliary Configuration", index);
		printf("\n");
		gsc_label_level_inc();
	}

	// Settings must be applied after the initialization call!

	errs	+= ai32ssc_aux_clk_mode	(fd, index, verbose, AI32SSC_AUX_CLK_MODE_DISABLE,	NULL);
	errs	+= ai32ssc_aux_in_pol	(fd, index, verbose, AI32SSC_AUX_IN_POL_LO_2_HI,	NULL);
	errs	+= ai32ssc_aux_noise	(fd, index, verbose, AI32SSC_AUX_NOISE_HIGH,		NULL);
	errs	+= ai32ssc_aux_out_pol	(fd, index, verbose, AI32SSC_AUX_OUT_POL_HI_PULSE,	NULL);
	errs	+= ai32ssc_aux_sync_mode(fd, index, verbose, AI32SSC_AUX_SYNC_MODE_DISABLE,	NULL);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


