// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_burst_busy.c $
// $Rev: 53690 $
// $Date: 2023-09-07 13:47:54 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_burst_busy
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_BURST_BUSY service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	ai32ssc_burst_busy(int fd, int index, int verbose, s32* get)
{
	char	buf[128];
	int		errs;
	int		ret;
	s32		set;

	if (verbose)
		gsc_label_index("Burst Busy", index);

	ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_BURST_BUSY, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			sprintf(buf, "INVALID: %ld", (long) set);
			break;

		case AI32SSC_BURST_BUSY_IDLE:

			strcpy(buf, "Idle");
			break;

		case AI32SSC_BURST_BUSY_ACTIVE:

			strcpy(buf, "Active");
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


