// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_ain_buf_underflow.c $
// $Rev: 53690 $
// $Date: 2023-09-07 13:47:54 -0500 (Thu, 07 Sep 2023) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_ain_buf_underflow
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_AIN_BUF_UNDERFLOW service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		The setting to apply.
*
*		get		The current setting is recorded here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	ai32ssc_ain_buf_underflow(int fd, int index, int verbose, s32 set, s32* get)
{
	char	buf[128];
	int		errs;
	int		ret;

	if (verbose)
		gsc_label_index("Input Buffer Underflow", index);

	ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_AIN_BUF_UNDERFLOW, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			sprintf(buf, "INVALID: %ld", (long) set);
			break;

		case AI32SSC_AIN_BUF_UNDERFLOW_NO:

			strcpy(buf, "No");
			break;

		case AI32SSC_AIN_BUF_UNDERFLOW_YES:

			strcpy(buf, "Yes");
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


