// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/util_ain_buf_clear.c $
// $Rev: 42823 $
// $Date: 2018-05-17 16:36:31 -0500 (Thu, 17 May 2018) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_ain_buf_clear
*
*	Purpose:
*
*		Provide a visual wrapper for the AI32SSC_IOCTL_AIN_BUF_CLEAR service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		at_bndy	Clear the buffer at a scan boundary?
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	ai32ssc_ain_buf_clear(int fd, int index, int verbose, int at_bndy)
{
	s32	enabled	= AI32SSC_ADC_ENABLE_NO;
	int	errs	= 0;
	int	ret;

	if (verbose)
		gsc_label_index("Input Buffer Clear", index);

	if (at_bndy)
	{
		errs	+= ai32ssc_adc_enable(fd, -1, 0, -1, &enabled);

		// ADC Disable as needed.

		if (enabled == AI32SSC_ADC_ENABLE_YES)
			errs	+= ai32ssc_adc_enable(fd, -1, 0, AI32SSC_ADC_ENABLE_NO, NULL);

		// Clear the buffer with any over or under flow status.
		ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_AIN_BUF_CLEAR, NULL);
		errs	+= ret ? 1 : 0;

		// ADC Enable as needed.

		if (enabled == AI32SSC_ADC_ENABLE_YES)
			errs	+= ai32ssc_adc_enable(fd, -1, 0, AI32SSC_ADC_ENABLE_YES, NULL);
	}
	else
	{
		ret		= ai32ssc_ioctl(fd, AI32SSC_IOCTL_AIN_BUF_CLEAR, NULL);
		errs	+= ret ? 1 : 0;
	}

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}


