// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/utils/init.c $
// $Rev: 54761 $
// $Date: 2024-07-01 17:03:44 -0500 (Mon, 01 Jul 2024) $

// 16AI32SSC: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ai32ssc_init_util
*
*	Purpose:
*
*		Implement a visual wrapper around the API init call.
*
*	Arguments:
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ai32ssc_init_util(int verbose)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label("API Initialize");

	ret		= ai32ssc_init();
	errs	= (ret < 0) ? 1 : 0;

	if (verbose == 0)
		;
	else if (errs)
		printf("FAIL <---  (ret = %d)\n", ret);
	else
		printf("PASS\n");

	return(errs);
}



