// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/tt/perform.c $
// $Rev: 51368 $
// $Date: 2022-07-12 16:43:34 -0500 (Tue, 12 Jul 2022) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_1M		(1024L * 1024L)



// variables ******************************************************************

static	u32	_buffer[_1M];



//*****************************************************************************
static int _channels(const args_t* args, s32* chans)
{
	int	errs	= 0;
	u32	mask;
	int	ret;
	u32	v;

	gsc_label("TT Input Channels");

	mask	= 0xFFFFFFFF;
	ret		= ai32ssc_ioctl(args->fd, AI32SSC_IOCTL_TT_CHAN_MASK, &mask);
	errs	+= ret ? 1 : 0;

	for (chans[0] = 0, v = mask; v; v /= 2)
	{
		if (v & 1)
			chans[0]++;
	}

	if (errs == 0)
		printf("PASS  (%ld active, 0x%08lX)\n", (long) chans[0], (long) mask);

	return(errs);
}



//*****************************************************************************
static int _read_data(const args_t* args)
{
	int		errs	= 0;
	long	get		= sizeof(_buffer);
	int		got;

	gsc_label("Reading");
	got	= ai32ssc_read(args->fd, _buffer, get);

	if (got < 0)
	{
		errs	= 1;
	}
	else if (got != get)
	{
		errs	= 1;
		printf(	"FAIL <---  (got %ld samples, requested %ld)\n",
				(long) got / 4,
				(long) get / 4);
	}
	else
	{
		errs	= 0;
		printf(	"PASS  (%ld samples)\n",
				(long) got / 4);
	}

	return(errs);
}



//*****************************************************************************
static int _save_data(int errs)
{
	FILE*		file;
	int			i;
	long		l;
	const char*	name	= "timetag.txt";
	int			qty;
	long		samples	= sizeof(_buffer) / 4;

	gsc_label("Saving");

	for (;;)
	{
		if (errs)
		{
			printf("SKIPPED  (errors)\n");
			errs	= 0;
			break;
		}

		file	= fopen(name, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", name);
			errs	= 1;
			break;
		}

		for (l = 0; samples; l++, samples--)
		{
			if (_buffer[l] & 0x80000000)
			{
				qty	= 2;
				i	= fprintf(file, "\r\n");
				// This is the Time Tag header

				if (samples < 4)
					break;

				qty	= 74;
				i	+= fprintf(file, "  %08lX", (long) _buffer[l + 0]);
				i	+= fprintf(file, "  %08lX", (long) _buffer[l + 1]);
				i	+= fprintf(file, "  %08lX", (long) _buffer[l + 2]);
				i	+= fprintf(file, "  %08lX", (long) _buffer[l + 3]);

				i	+= fprintf(file, "  ");
				i	+= fprintf(file, "(%04lX", (long) _buffer[l + 2] & 0xFFFF);
				i	+= fprintf(file, " %04lX", (long) _buffer[l + 1] & 0xFFFF);
				i	+= fprintf(file, " %04lX", (long) _buffer[l + 0] & 0xFFFF);
				i	+= fprintf(file, ", %2ld samples)\r\n", (long) _buffer[l + 3] & 0xFFFF);

				l		+= 3;
				samples	-= 3;
			}
			else
			{
				qty	= 10;
				i	= fprintf(file, "  %08lX", (long) _buffer[l]);
			}

			if (i != qty)
			{
				printf("FAIL <---  (fprintf() failure on %s)\n", name);
				errs	= 1;
				break;
			}
		}

		fclose(file);

		if (errs == 0)
			printf("PASS  (%s)\n", name);

		break;
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	s32	chans		= 32;
	int	errs		= 0;
	s32	nrate_a		= 2000;
	s32	nrate_tt	= 2;
	s32	tt			= 0;

	errs	+= ai32ssc_query(args->fd, -1, 0, AI32SSC_QUERY_TIME_TAG, &tt);

	if (errs)
	{
	}
	else if (tt == 0)
	{
		printf("SKIPPED  (Time Tagging not supported on this device.)\n");
	}
	else
	{
		errs	+= ai32ssc_config_tt(args->fd, -1, 1, nrate_a, nrate_tt);

		errs	+= ai32ssc_tt_enable		(args->fd, -1, 1, AI32SSC_TT_ENABLE_YES, NULL);
		errs	+= ai32ssc_tt_adc_enable	(args->fd, -1, 1, AI32SSC_TT_ADC_ENABLE_YES, NULL);
// Some non-current firmware fails to properly perform DMA/DMDMA with Time Tag enabled.
//		errs	+= ai32ssc_rx_io_mode		(args->fd, -1, 1, GSC_IO_MODE_DMDMA, NULL);
		errs	+= _channels(args, &chans);
		errs	+= ai32ssc_fsamp_report_all	(args->fd, -1, 1, 0);
		errs	+= ai32ssc_ain_buf_clear	(args->fd, -1, 1, 1);
		errs	+= ai32ssc_ain_buf_clear	(args->fd, -1, 1, 1);
		errs	+= _read_data(args);
		errs	+= ai32ssc_ain_buf_overflow	(args->fd, -1, 1, -1, NULL);
		errs	+= ai32ssc_ain_buf_underflow(args->fd, -1, 1, -1, NULL);
		errs	+= _save_data(errs);
	}

	return(errs);
}



