// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/snapshot/wait_ll.c $
// $Rev: 54732 $
// $Date: 2024-07-01 08:13:38 -0500 (Mon, 01 Jul 2024) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
// Wait for the Sync Done interrupt, then read data via the Low Latency
// feature. This is a very efficient method. This method does not rely upon a
// specific I/O Timeout setting.
//*****************************************************************************
int rx_wait_ll(const args_t* args, rx_data_t* rx, gsc_buf_man_t* bm)
{
	s32					arg;
	ai32ssc_ll_data_t	ll;
	int					ms;
	int					ret			= 0;
	int					scan_size	= 4 * rx->chan_qty;
	gsc_wait_t			wait;

	for (;;)	// A convenience loop.
	{
		// Enable the SYNC Done interrupt.
		arg	= AI32SSC_IRQ0_SYNC_DONE;
		ret	= ai32ssc_ioctl(args->fd, AI32SSC_IOCTL_IRQ0_SEL, &arg);

		if (ret < 0)
		{
			bm->eof		= 1;
			bm->count	= 0;
			rx->errs	= 1;
			sprintf(rx->err_buf, "IRQ0 enable failure: %d", ret);
			break;
		}

		// Compute the Wait Event timeout as about 2ms longer than needed.
		ms	= (int) (1000.0 / rx->fsamp + 2.5);	// round up

		// Wait for the SYNC Done interrupt.
		wait.flags		= 0;
		wait.main		= 0;
		wait.gsc		= AI32SSC_WAIT_GSC_SYNC_DONE;
		wait.alt		= 0;
		wait.io			= 0;
		wait.timeout_ms	= ms;
		wait.count		= 0;
		ret	= ai32ssc_ioctl(args->fd, AI32SSC_IOCTL_WAIT_EVENT, &wait);

		if (ret < 0)
		{
			bm->eof		= 1;
			bm->count	= 0;
			rx->errs	= 1;
			sprintf(rx->err_buf, "Wait Event failure: %d", ret);
			break;
		}

		if (wait.flags & GSC_WAIT_FLAG_DONE)
		{
			rx->wait_done++;
		}
		else if (wait.flags & GSC_WAIT_FLAG_TIMEOUT)
		{
			rx->wait_timeout++;
		}

		// Read in the data. ==============================
		rx->read_calls++;
		ll.mask	= GSC_FIELD_ENCODE(0xFFFFFFFF, rx->chan_qty - 1, 0);
		ret	= ai32ssc_ioctl(args->fd, AI32SSC_IOCTL_LL_READ, &ll);

		if (ret < 0)
		{
			bm->eof		= 1;
			bm->count	= 0;
			rx->errs	= 1;
			sprintf(rx->err_buf, "LL read failure: %d", (int) ret);
			break;
		}

		ret	= scan_size;
		break;
	}

	return(ret);
}


