// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/snapshot/poll_read.c $
// $Rev: 54732 $
// $Date: 2024-07-01 08:13:38 -0500 (Mon, 01 Jul 2024) $

// 16AI32SSC: Sample Application: source file

#include "main.h"



//*****************************************************************************
// Poll by calling the read service. The call returns at least on scan of data
// when data becomes available. If the volume of data returned is over one
// scan's worth of data, then clear the FIFO. Data appears in the FIFO one scan
// at a time. This is a very inefficient means of obtaining data, which is
// typical of polling methods. This method requires an I/O Timeout setting of
// zero, which guarantees that the read call does not block.
//*****************************************************************************
int rx_poll_read(const args_t* args, rx_data_t* rx, gsc_buf_man_t* bm)
{
	int	ret			= 0;
	int	rx_bytes	= 4 * rx->chan_qty;
	int	scan_size	= 4 * rx->chan_qty;
	int	tmp;

	if (args->data_pack)
	{
		rx_bytes	= (scan_size / 2) + ((rx->chan_qty & 1) ? 2 : 0);
		scan_size	= scan_size / 2;
	}

	for (;;)	// A convenience loop.
	{
		// Read in the data.
		rx->read_calls++;
		ret	= ai32ssc_read(args->fd, bm->buffer, rx_bytes);

		if (ret == 0)
			continue;	// we received no data

		if (ret < 0)
		{
			bm->eof		= 1;
			bm->count	= 0;
			rx->errs	= 1;
			sprintf(rx->err_buf, "Rx read failure: %d", (int) ret);
			break;
		}

		// Clear the buffer in case the sample rate is too fast.
		tmp	= ai32ssc_ioctl(args->fd, AI32SSC_IOCTL_AIN_BUF_CLEAR, NULL);

		if (tmp)
		{
			ret			= tmp;
			bm->eof		= 1;
			bm->count	= 0;
			rx->errs	= 1;
			sprintf(rx->err_buf, "AI Buffer Clear failure: %d", (int) tmp);
			break;
		}

		ret	= scan_size;
		break;
	}

	return(ret);
}


