// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AI32SSC/samples/snapshot/main.h $
// $Rev: 54732 $
// $Date: 2024-07-01 08:13:38 -0500 (Mon, 01 Jul 2024) $

// 16AI32SSC: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "16ai32ssc_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)				(sizeof((a)) / sizeof((a)[0]))
#define	ERROR_INTERNAL_INT(i)		error_internal_int(__LINE__, __FILE__, (i))
#define	ERROR_INTERNAL_RX_INT(rx,i)	error_internal_rx_int((rx),__LINE__, __FILE__, (i))

#define	RX_OPTION_ZERO_DATA			0
#define	RX_OPTION_READ_DEV			1

#define	TX_OPTION_BIT_BUCKET		0
#define	TX_OPTION_WRITE_FILE_BIN	1
#define	TX_OPTION_WRITE_FILE_TEXT	2

#define	BUFFER_QTY					4
#define	BUFFER_SIZE					(64 * 4)

#define	CHAN_TAG_EXCLUDE			1
#define	CHAN_TAG_ONLY				2

#define	RX_DATA_POLL_FIFO			1
#define	RX_DATA_POLL_READ			2
#define	RX_DATA_WAIT_LL				3
#define	RX_DATA_WAIT_READ			4



// data types *****************************************************************

typedef struct
{
	s32				chan_qty;		// Set by controlling thread to number of channels on device.
	s32				fsamp;			// set by controlling thread to the requested sample rate.
	int				start;			// set by controlling thread to request that we start processing
	int				stop;			// set by controlling thread to request that we stop processing
	os_thread_t		thread;			// Set by controlling thread when thread is created

	long long		byte_limit;		// set by new thread to min bytes to read.
	int				done;			// set by new thread to report that it is done
	int				errs;			// Set by new thread to report any errors
	char			err_buf[2048];	// Set by new thread to describe error condition.
	double			overall_rate;	// Set by new thread to achieved overall throughput rate
	int				read_calls;		// Set by new thread to report number of calls made.
	s32				reading;		// set by new thread to indicate data Rx has started.
	os_time_ns_t	start_time;		// Set by new thread to indicate when Rx processing started.
	int				started;		// set by new thread to indicate it has started
	os_time_ns_t	time_limit;		// Set by new thread when thread should stop read effort
	os_time_ns_t	time_start;		// Set by new thread when thread starts read effort
	os_time_ns_t	time_stop;		// Set by new thread when thread stops read effort
	long long		total_bytes;	// Set by new thread for accounting purposes
	long			total_ms;		// Set by new thread for accounting purposes
	int				wait_done;		// Set by new thread for Wait Event Done status
	int				wait_timeout;	// Set by new thread for Wait Event Timeout status
} rx_data_t;

typedef struct
{
	s32				chan_qty;		// Set by controlling thread to number of channels on device.
	FILE*			file;			// Set by controlling thread for data destination.
	int				start;			// set by controlling thread to request that we start processing
	int				stop;			// set by controlling thread to request that we stop processing
	os_thread_t		thread;			// Set by controlling thread when thread is created

	int				done;			// set by new thread to report that it is done
	int				errs;			// Set by new thread to report any errors
	char			err_buf[2048];	// Set by new thread to describe error condition.
	char			name[256];		// Set by new thread for data destination.
	double			overall_rate;	// Set by new thread to achieved overall throughput rate
	int				started;		// set by new thread to indicate it has started
	os_time_ns_t	time_start;		// Set by new thread when thread starts Tx effort
	os_time_ns_t	time_stop;		// Set by new thread when thread stops Tx effort
	long long		total_bytes;	// Set by new thread for accounting purposes
	long			total_ms;		// Set by new thread for accounting purposes
} tx_data_t;

typedef struct
{
	// Application Settings

	s32	chan_qty;		// Number of chnnels to use.
	s32	delay_s;		// Delay for # seconds before each -r iteration.
	s32	force;			// Force operation even if errors occur.
	s32	index;			// device index
	int	qty;			// Number of devices detected.
	s32	range;			// Run a range test from MIN to MAX via INC
	s32	range_inc;		// Adjust range test by # S/S per test.
	s32	range_max;		// Stop the range test at # S/S.
	s32	range_min;		// Start the range test at # S/S.
	s32	rx_data;		// RX_DATA_XXX
	s32	rx_mb;			// Read a minimum of # megabytes of data.
	s32	rx_option;
	s32	rx_seconds;		// Read for # seconds.
	s32	stats;
	s32	tx_decimal;		// Save .txt file content as decimal. Otherwise as hex.
	s32	tx_option;
	s32	tx_chan_tag;	// Channel Tag: exclude or only

	int	fd;				// File descriptor for device to access.

	// Device Settings

	s32	data_pack;		// Enable Data Packing?
	s32	fsamp;
	s32	io_mode;

	// Additional Fields
	rx_data_t*	rx;
	tx_data_t*	tx;
} args_t;



// prototypes *****************************************************************

int		error_internal_int(int line, const char* file, int i);
int		error_internal_rx_int(rx_data_t* rx, int line, const char* file, int i);

int		perform_tests(const args_t* args);
void	perform_text(const args_t* args, int label, const char* single, const char* range);

int		rx_poll_fifo(const args_t* args, rx_data_t* rx, gsc_buf_man_t* bm);
int		rx_poll_read(const args_t* args, rx_data_t* rx, gsc_buf_man_t* bm);
int		rx_start(const args_t* args);
int		rx_stop(const args_t* args);
int		rx_wait_ll(const args_t* args, rx_data_t* rx, gsc_buf_man_t* bm);
int		rx_wait_read(const args_t* args, rx_data_t* rx, gsc_buf_man_t* bm);

int		tx_start(const args_t* args);
int		tx_stop(const args_t* args);



#endif
